/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class CableNetworkNode
extends NetworkNode
implements ICoverable {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "cable");
    private final CoverManager coverManager = new CoverManager(this);

    public CableNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Override
    public boolean canConduct(Direction direction) {
        return !this.coverManager.hasCover(direction) || this.coverManager.getCover(direction).getType() == CoverType.HOLLOW;
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getCable().getUsage();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }

    @Override
    public void read(CompoundTag tag) {
        if (tag.m_128441_(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.m_128469_(CoverManager.NBT_COVER_MANAGER));
        }
        super.read(tag);
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        tag.m_128365_(CoverManager.NBT_COVER_MANAGER, (Tag)this.coverManager.writeToNbt());
        return super.write(tag);
    }
}

