/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders;

import com.anthonyhilyard.iceberg.config.IcebergConfig;
import com.anthonyhilyard.iceberg.config.IcebergConfigSpec;
import com.anthonyhilyard.iceberg.util.Selectors;
import com.anthonyhilyard.prism.item.ItemColors;
import com.anthonyhilyard.prism.util.ConfigHelper;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="itemborders", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItemBordersConfig
extends IcebergConfig<ItemBordersConfig> {
    private static ItemBordersConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue hotBar;
    public final ForgeConfigSpec.BooleanValue showForCommon;
    public final ForgeConfigSpec.BooleanValue squareCorners;
    public final ForgeConfigSpec.BooleanValue fullBorder;
    public final ForgeConfigSpec.BooleanValue overItems;
    public final ForgeConfigSpec.BooleanValue extraGlow;
    public final ForgeConfigSpec.BooleanValue automaticBorders;
    public final ForgeConfigSpec.BooleanValue legendaryTooltipsSync;
    private final ForgeConfigSpec.ConfigValue<UnmodifiableConfig> manualBorders;
    private Map<ItemKey, Pair<Supplier<Integer>, Supplier<Integer>>> cachedCustomBorders = new HashMap<ItemKey, Pair<Supplier<Integer>, Supplier<Integer>>>();
    private boolean emptyCache = true;
    private static final UnmodifiableConfig emptySubconfig;

    public static ItemBordersConfig getInstance() {
        return INSTANCE;
    }

    public ItemBordersConfig(IcebergConfigSpec.Builder build) {
        int i;
        build.comment("Client Configuration").push("client").push("options");
        this.hotBar = build.comment(" If the hotbar should display item borders.").define("hotbar", true);
        this.showForCommon = build.comment(" If item borders should show for common items.").define("show_for_common", false);
        this.squareCorners = build.comment(" If the borders should have square corners.").define("square_corners", true);
        this.fullBorder = build.comment(" If the borders should fully envelop item slots (otherwise they will only show on the bottom portion of the slot).").define("full_border", false);
        this.overItems = build.comment(" If the borders draw over items instead of under.").define("over_items", false);
        this.extraGlow = build.comment(" If the borders should have a more prominent glow.").define("extra_glow", false);
        this.automaticBorders = build.comment(" If automatic borders (based on item rarity) should be enabled.").define("auto_borders", true);
        this.legendaryTooltipsSync = build.comment(" If enabled and Legendary Tooltips is installed, borders will sync with tooltip border colors.").define("legendary_tooltips_sync", false);
        StringBuilder entriesComment = new StringBuilder(" Custom border colors for specific items. Format: { <color> = [\"list of selectors\"] }.\n Color formats supported:\n");
        for (ConfigHelper.ColorFormatDocumentation doc : ConfigHelper.colorFormatDocumentation((boolean)true)) {
            entriesComment.append("   ").append(doc.name()).append(" - ").append(doc.description().replace("\n\n", "\n").replace("\n", "\n     "));
            if (!doc.examples().isEmpty()) {
                entriesComment.append("  Examples: ");
                for (i = 0; i < doc.examples().size(); ++i) {
                    if (((String)doc.examples().get(0)).startsWith("Using")) {
                        if (i == 0) {
                            entriesComment.setLength(entriesComment.length() - 18);
                            entriesComment.append("  ");
                        }
                        if (i > 1) {
                            entriesComment.append(", ");
                        }
                        entriesComment.append((String)doc.examples().get(i));
                        if (i != 0) continue;
                        entriesComment.append("     Examples: ");
                        continue;
                    }
                    if (i > 0) {
                        entriesComment.append(", ");
                    }
                    entriesComment.append((String)doc.examples().get(i));
                }
            }
            entriesComment.append("\n");
        }
        entriesComment.append(" Selectors supported:\n");
        for (ConfigHelper.ColorFormatDocumentation doc : Selectors.selectorDocumentation()) {
            entriesComment.append("   ").append(doc.name()).append(" - ").append(doc.description());
            if (!doc.examples().isEmpty()) {
                entriesComment.append("  Examples: ");
                for (i = 0; i < doc.examples().size(); ++i) {
                    if (i > 0) {
                        entriesComment.append(", ");
                    }
                    entriesComment.append("\"").append((String)doc.examples().get(i)).append("\"");
                }
            }
            entriesComment.append("\n");
        }
        entriesComment.setLength(entriesComment.length() - 1);
        this.manualBorders = build.comment(entriesComment.toString()).defineSubconfig("manual_borders", emptySubconfig, k -> ItemBordersConfig.validateColor(k), v -> Selectors.validateSelector((String)((String)v)));
        build.pop().pop();
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading e) {
        if (e.getConfig().getModId().equals("itemborders")) {
            ItemBordersConfig.INSTANCE.emptyCache = true;
        }
    }

    public static TextColor getColor(Object value) {
        return (TextColor)ConfigHelper.parseColor((Object)value);
    }

    private static boolean validateColor(Object value) {
        return ItemBordersConfig.getColor(value) != null;
    }

    public Pair<Supplier<Integer>, Supplier<Integer>> getBorderColorForItem(ItemStack item) {
        ItemKey itemKey = new ItemKey(item.m_41720_(), item.m_41783_());
        if (this.emptyCache) {
            this.emptyCache = false;
            this.cachedCustomBorders.clear();
        }
        if (this.cachedCustomBorders.containsKey(itemKey)) {
            return this.cachedCustomBorders.get(itemKey);
        }
        Map manualBorderMap = ((UnmodifiableConfig)this.manualBorders.get()).valueMap();
        for (String key : manualBorderMap.keySet()) {
            TextColor color = ItemBordersConfig.getColor(key);
            Pair colors = new Pair(() -> color.m_131265_(), () -> color.m_131265_());
            if (color == null) continue;
            Object value = manualBorderMap.get(key);
            if (value instanceof String) {
                if (!Selectors.itemMatches((ItemStack)item, (String)((String)value))) continue;
                this.cachedCustomBorders.put(itemKey, (Pair<Supplier<Integer>, Supplier<Integer>>)colors);
                return colors;
            }
            if (!(value instanceof List)) continue;
            List valueList = (List)value;
            for (Object stringVal : valueList) {
                if (!(stringVal instanceof String) || !Selectors.itemMatches((ItemStack)item, (String)((String)stringVal))) continue;
                this.cachedCustomBorders.put(itemKey, (Pair<Supplier<Integer>, Supplier<Integer>>)colors);
                return colors;
            }
        }
        Pair colors = null;
        if (((Boolean)ItemBordersConfig.INSTANCE.automaticBorders.get()).booleanValue()) {
            TextColor color = ItemColors.getColorForItem((ItemStack)item, null);
            colors = new Pair(() -> color.m_131265_(), () -> color.m_131265_());
        }
        if (ModList.get().isLoaded("legendarytooltips") && ((Boolean)ItemBordersConfig.INSTANCE.legendaryTooltipsSync.get()).booleanValue()) {
            Pair borderColors = null;
            try {
                borderColors = (Pair)Class.forName("com.anthonyhilyard.itemborders.compat.LegendaryTooltipsHandler").getMethod("getBorderColors", ItemStack.class).invoke(null, item);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (borderColors != null) {
                colors = borderColors;
            }
        }
        this.cachedCustomBorders.put(itemKey, colors);
        return colors;
    }

    protected <I extends IcebergConfig<?>> void setInstance(I instance) {
        INSTANCE = (ItemBordersConfig)instance;
    }

    static {
        emptySubconfig = new ForgeConfigSpec.Builder().build();
    }

    private record ItemKey(Item item, CompoundTag tag) {
    }
}

