/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.finalcastle;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.TFStructureComponentOld;

public class FinalCastleMuralComponent
extends TFStructureComponentOld {
    private int height;
    private int width;
    private byte[][] mural;

    public FinalCastleMuralComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFFCMur.get(), nbt);
    }

    public FinalCastleMuralComponent(int i, int x, int y, int z, int width, int height, Direction direction) {
        super((StructurePieceType)TFStructurePieceTypes.TFFCMur.get(), i, x, y, z);
        this.m_73519_(direction);
        this.f_73383_ = TFStructureComponentOld.getComponentToAddBoundingBox2(x, y, z, 0, -height / 2, -width / 2, 1, height - 1, width - 1, direction);
    }

    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.height = this.f_73383_.m_71057_();
        this.width = this.m_73549_() == Direction.SOUTH || this.m_73549_() == Direction.NORTH ? this.f_73383_.m_71058_() : this.f_73383_.m_71056_();
        RandomSource decoRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)this.f_73383_.m_162395_() * 321534781L ^ (long)this.f_73383_.m_162398_() * 756839L));
        if (this.mural == null) {
            this.mural = new byte[this.width][this.height];
            int startX = this.width / 2 - 1;
            int startY = 2;
            for (int x = -1; x < 2; ++x) {
                for (int y = -1; y < 2; ++y) {
                    this.mural[startX + x][startY + y] = 1;
                }
            }
            this.makeHorizontalTree(decoRNG, this.mural, startX + 1, startY, decoRNG.m_188503_(this.width / 6) + this.width / 6, true);
            this.makeHorizontalTree(decoRNG, this.mural, startX - 1, startY, decoRNG.m_188503_(this.width / 6) + this.width / 6, false);
            this.makeVerticalTree(decoRNG, this.mural, startX, startY + 1, decoRNG.m_188503_(this.height / 6) + this.height / 6, true);
            this.makeStripes(decoRNG);
        }
        BlockState castleMagic = ((Block)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get()).m_49966_();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.mural[x][y] <= 0) continue;
                this.m_73434_(world, castleMagic, 0, y, x, sbb);
            }
        }
    }

    private void makeHorizontalTree(RandomSource decoRNG, byte[][] mural, int centerX, int centerY, int branchLength, boolean positive) {
        this.fillHorizontalLine(mural, centerX, centerY, branchLength, positive);
        this.makeHorizontalBranch(mural, decoRNG, centerX, centerY, branchLength, positive, true);
        this.makeHorizontalBranch(mural, decoRNG, centerX, centerY, branchLength, positive, false);
    }

    private void makeVerticalTree(RandomSource decoRNG, byte[][] mural, int centerX, int centerY, int branchLength, boolean positive) {
        this.fillVerticalLine(mural, centerX, centerY, branchLength, positive);
        this.makeVerticalBranch(mural, decoRNG, centerX, centerY, branchLength, positive, true);
        this.makeVerticalBranch(mural, decoRNG, centerX, centerY, branchLength, positive, false);
    }

    private boolean makeHorizontalBranch(byte[][] mural, RandomSource rand, int sx, int sy, int length, boolean plusX, boolean plusY) {
        int downLine = length / 2 + 1 + rand.m_188503_(Math.max(length / 2, 2));
        int branchLength = rand.m_188503_(this.width / 8) + this.width / 8;
        boolean clear = true;
        for (int i = 0; i <= branchLength; ++i) {
            int cx = sx + (plusX ? downLine - 1 + i : -(downLine - 1 + i));
            int cy = sy + (plusY ? 2 : -2);
            if (cx >= 0 && cx < this.width && cy >= 0 && cy < this.height && mural[cx][cy] <= 0) continue;
            clear = false;
            break;
        }
        if (clear) {
            int bx = sx + (plusX ? downLine : -downLine);
            int by = sy;
            this.fillVerticalLine(mural, bx, by, 1, plusY);
            this.fillHorizontalLine(mural, bx, by += plusY ? 2 : -2, branchLength, plusX);
            if (bx > 0 && bx < this.width && by > 0 && by < this.height) {
                if (!(this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, true) || this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, true) || this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, true))) {
                    this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, true);
                }
                if (!(this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, false) || this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, false) || this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, false))) {
                    this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, false);
                }
            }
            return true;
        }
        return false;
    }

    private boolean makeVerticalBranch(byte[][] mural, RandomSource rand, int sx, int sy, int length, boolean plusY, boolean plusX) {
        int downLine = length / 2 + 1 + rand.m_188503_(Math.max(length / 2, 2));
        int branchLength = rand.m_188503_(this.height / 8) + this.height / 8;
        boolean clear = true;
        for (int i = 0; i <= branchLength; ++i) {
            int cx = sx + (plusX ? 2 : -2);
            int cy = sy + (plusY ? downLine - 1 + i : -(downLine - 1 + i));
            if (cx >= 0 && cx < this.width && cy >= 0 && cy < this.height && mural[cx][cy] <= 0) continue;
            clear = false;
            break;
        }
        if (clear) {
            int bx = sx;
            int by = sy + (plusY ? downLine : -downLine);
            this.fillHorizontalLine(mural, bx, by, 1, plusX);
            this.fillVerticalLine(mural, bx += plusX ? 2 : -2, by, branchLength, plusY);
            if (bx > 0 && bx < this.width && by > 0 && by < this.height) {
                if (!(this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, true) || this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, true) || this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, true))) {
                    this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, true);
                }
                if (!(this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, false) || this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, false) || this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, false))) {
                    this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, false);
                }
            }
            return true;
        }
        return false;
    }

    private void fillHorizontalLine(byte[][] mural, int sx, int sy, int length, boolean positive) {
        int x = sx;
        int y = sy;
        for (int i = 0; i <= length; ++i) {
            if (x < 0 || x >= this.width || y < 0 || y >= this.height) continue;
            mural[x][y] = (byte)(positive ? 1 : 4);
            x += positive ? 1 : -1;
        }
    }

    private void fillVerticalLine(byte[][] mural, int sx, int sy, int length, boolean positive) {
        int x = sx;
        int y = sy;
        for (int i = 0; i <= length; ++i) {
            if (x < 0 || x >= this.width || y < 0 || y >= this.height) continue;
            mural[x][y] = (byte)(positive ? 2 : 3);
            y += positive ? 1 : -1;
        }
    }

    private void makeStripes(RandomSource decoRNG) {
        for (int y = this.height - 2; y > this.height / 3; y -= 2 + decoRNG.m_188503_(2)) {
            this.makeSingleStripe(y);
        }
    }

    private void makeSingleStripe(int y) {
        int x;
        for (x = 0; x < this.width - 2 && this.mural[x + 1][y] == 0 && this.mural[x + 1][y + 1] == 0; ++x) {
            this.mural[x][y] = 1;
        }
        for (x = this.width - 1; x > 2 && this.mural[x - 1][y] == 0 && this.mural[x - 1][y + 1] == 0; --x) {
            this.mural[x][y] = 1;
        }
    }
}

