/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.LongFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.world.components.layer.IThornsTransformer;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerType;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;

public record BorderLayer(ResourceKey<Biome> targetBiome, ResourceKey<Biome> borderBiome) implements IThornsTransformer
{
    @Override
    public ResourceKey<Biome> apply(Context noise, ResourceKey<Biome> up, ResourceKey<Biome> left, ResourceKey<Biome> down, ResourceKey<Biome> right, ResourceKey<Biome> center, ResourceKey<Biome> nw, ResourceKey<Biome> sw, ResourceKey<Biome> se, ResourceKey<Biome> ne) {
        if (BorderLayer.onBorder(this.targetBiome, center, right, left, up, down)) {
            return this.borderBiome;
        }
        if (BorderLayer.onBorder(this.targetBiome, center, ne, nw, se, sw)) {
            return this.borderBiome;
        }
        return center;
    }

    private static boolean onBorder(ResourceKey<Biome> biomeID, ResourceKey<Biome> center, ResourceKey<Biome> right, ResourceKey<Biome> left, ResourceKey<Biome> up, ResourceKey<Biome> down) {
        return center != biomeID && (right == biomeID || left == biomeID || up == biomeID || down == biomeID);
    }

    public static final class Factory
    implements BiomeLayerFactory {
        public static final Codec<Factory> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.LONG.fieldOf("salt").forGetter(Factory::salt), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_).fieldOf("target_biome").forGetter(Factory::target), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_).fieldOf("bordering_biome").forGetter(Factory::borderingBiome), (App)BiomeLayerStack.HOLDER_CODEC.fieldOf("parent").forGetter(Factory::parent)).apply((Applicative)inst, Factory::new));
        private final long salt;
        private final ResourceKey<Biome> target;
        private final ResourceKey<Biome> borderingBiome;
        private final Holder<BiomeLayerFactory> parent;
        private final BorderLayer instance;

        public Factory(long salt, ResourceKey<Biome> centerBiome, ResourceKey<Biome> borderingBiome, Holder<BiomeLayerFactory> parent) {
            this.salt = salt;
            this.target = centerBiome;
            this.borderingBiome = borderingBiome;
            this.parent = parent;
            this.instance = new BorderLayer(centerBiome, borderingBiome);
        }

        @Override
        public LazyArea build(LongFunction<LazyAreaContext> contextFactory) {
            return this.instance.run(contextFactory.apply(this.salt), ((BiomeLayerFactory)this.parent.get()).build(contextFactory));
        }

        @Override
        public BiomeLayerType getType() {
            return (BiomeLayerType)BiomeLayerTypes.BORDER.get();
        }

        public long salt() {
            return this.salt;
        }

        public ResourceKey<Biome> target() {
            return this.target;
        }

        public ResourceKey<Biome> borderingBiome() {
            return this.borderingBiome;
        }

        public Holder<BiomeLayerFactory> parent() {
            return this.parent;
        }
    }
}

