/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeatureLogic;
import twilightforest.util.VoxelBresenhamIterator;

@ParametersAreNonnullByDefault
public abstract class CanopyMushroomFeature
extends AbstractHugeMushroomFeature {
    private int bugsLeft;

    public CanopyMushroomFeature(Codec<HugeMushroomFeatureConfiguration> featureConfigurationCodec) {
        super(featureConfigurationCodec);
    }

    protected int m_6794_(int i, int i1, int foliageRadius, int treeHeight) {
        return treeHeight <= 3 ? 0 : (int)((float)foliageRadius * 1.5f);
    }

    protected void m_224929_(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, HugeMushroomFeatureConfiguration featureConfiguration, int height, BlockPos.MutableBlockPos mutableBlockPos) {
        for (int i = 0; i < height; ++i) {
            mutableBlockPos.m_122190_((Vec3i)pos).m_122175_(Direction.UP, i);
            if (!levelAccessor.m_8055_((BlockPos)mutableBlockPos).m_60804_((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) {
                this.m_5974_((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, featureConfiguration.f_67741_.m_213972_(random, pos));
                if (this.bugsLeft <= 0 || i <= height / 2 || random.m_188503_(10) != 9) continue;
                this.addFirefly(levelAccessor, (BlockPos)mutableBlockPos, random);
                continue;
            }
            height = i;
            break;
        }
        int numBranches = this.getBranches(random);
        float offset = random.m_188501_();
        for (int b = 0; b < numBranches; ++b) {
            this.buildABranch(levelAccessor, pos, height - 6 + b, this.getLength(random), 0.3 * (double)b + (double)offset, random, new HugeMushroomFeatureConfiguration(featureConfiguration.f_67740_, featureConfiguration.f_67741_, featureConfiguration.f_67742_ - 1));
        }
    }

    protected void addFirefly(LevelAccessor levelAccessor, BlockPos pos, RandomSource random) {
        Direction direction = Direction.m_235672_((RandomSource)random);
        if (direction.m_122434_() != Direction.Axis.Y) {
            BlockPos.MutableBlockPos bugPos = new BlockPos.MutableBlockPos();
            bugPos.m_122190_((Vec3i)pos).m_122173_(direction);
            if (!levelAccessor.m_8055_((BlockPos)bugPos).m_60804_((BlockGetter)levelAccessor, (BlockPos)bugPos)) {
                BlockState bugState = (BlockState)((Block)TFBlocks.FIREFLY.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)direction);
                this.m_5974_((LevelWriter)levelAccessor, (BlockPos)bugPos, bugState);
                --this.bugsLeft;
            }
        }
    }

    protected int m_224921_(RandomSource random) {
        return 9 + random.m_188503_(5);
    }

    protected abstract int getBranches(RandomSource var1);

    protected abstract double getLength(RandomSource var1);

    private void buildABranch(LevelAccessor levelAccessor, BlockPos pos, int height, double length, double angle, RandomSource random, HugeMushroomFeatureConfiguration featureConfiguration) {
        BlockState blockstate;
        BlockPos src = pos.m_6630_(height);
        BlockPos dest = FeatureLogic.translate(src, length, angle, 0.2);
        for (BlockPos pixel : new VoxelBresenhamIterator(src, new BlockPos(dest.m_123341_(), src.m_123342_(), dest.m_123343_()))) {
            blockstate = featureConfiguration.f_67741_.m_213972_(random, pos);
            if (blockstate.m_61138_((Property)HugeMushroomBlock.f_54131_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54132_)) {
                blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(true));
            }
            this.m_5974_((LevelWriter)levelAccessor, pixel, blockstate);
        }
        int max = Math.max(src.m_123342_(), dest.m_123342_());
        for (int i = Math.min(src.m_123342_(), dest.m_123342_()); i < max + 1; ++i) {
            blockstate = featureConfiguration.f_67741_.m_213972_(random, pos);
            if (blockstate.m_61138_((Property)HugeMushroomBlock.f_54132_) && i == Math.min(src.m_123342_(), dest.m_123342_())) {
                blockstate = (BlockState)blockstate.m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(true));
            }
            BlockPos blockPos = new BlockPos(dest.m_123341_(), i, dest.m_123343_());
            this.m_5974_((LevelWriter)levelAccessor, blockPos, blockstate);
            if (this.bugsLeft <= 0 || i <= Math.min(src.m_123342_(), dest.m_123342_()) / 2 || random.m_188503_(20) != 0) continue;
            this.addFirefly(levelAccessor, blockPos, random);
        }
        this.m_213950_(levelAccessor, random, dest, 1, new BlockPos.MutableBlockPos(), featureConfiguration);
    }

    protected void m_213950_(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        int i = featureConfiguration.f_67742_;
        for (int x = -i; x <= i; ++x) {
            for (int z = -i; z <= i; ++z) {
                boolean zMinMax;
                boolean xIsMin = x == -i;
                boolean xIsMax = x == i;
                boolean zIsMin = z == -i;
                boolean zIsMax = z == i;
                boolean xMinMax = xIsMin || xIsMax;
                boolean bl = zMinMax = zIsMin || zIsMax;
                if (xMinMax && zMinMax) continue;
                mutableBlockPos.m_122154_((Vec3i)pos, x, height, z);
                if (levelAccessor.m_8055_((BlockPos)mutableBlockPos).m_60804_((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) continue;
                boolean xMinOrZ = xIsMin || zMinMax && x == 1 - i;
                boolean xMaxOrZ = xIsMax || zMinMax && x == i - 1;
                boolean zMinOrX = zIsMin || xMinMax && z == 1 - i;
                boolean zMaxOrX = zIsMax || xMinMax && z == i - 1;
                BlockState blockstate = featureConfiguration.f_67740_.m_213972_(random, pos);
                if (blockstate.m_61138_((Property)HugeMushroomBlock.f_54130_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54128_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54127_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54129_)) {
                    blockstate = (BlockState)((BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(xMinOrZ))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(xMaxOrZ))).m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(zMinOrX))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(zMaxOrX));
                }
                this.m_5974_((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockstate);
            }
        }
    }

    public boolean m_142674_(FeaturePlaceContext<HugeMushroomFeatureConfiguration> context) {
        this.bugsLeft = Math.max(0, context.m_225041_().m_188503_(10) - 4) / 2;
        return super.m_142674_(context);
    }
}

