/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.VoxelBresenhamIterator;
import twilightforest.world.components.feature.config.RootConfig;

public class WoodRootFeature
extends Feature<RootConfig> {
    public WoodRootFeature(Codec<RootConfig> configIn) {
        super(configIn);
    }

    public boolean m_142674_(FeaturePlaceContext<RootConfig> ctx) {
        WorldGenLevel world = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        RandomSource rand = ctx.m_225041_();
        if (world.m_8055_(pos).m_60734_() != Blocks.f_50069_) {
            return false;
        }
        float length = rand.m_188501_() * 6.0f + rand.m_188501_() * 6.0f + 4.0f;
        if (length > (float)pos.m_123342_()) {
            length = pos.m_123342_();
        }
        float tilt = 0.6f + rand.m_188501_() * 0.3f;
        return this.drawRoot((LevelAccessor)world, rand, pos, pos, length, rand.m_188501_(), tilt, ((RootConfig)ctx.m_159778_()).blockRoot(), ((RootConfig)ctx.m_159778_()).oreRoot());
    }

    private boolean drawRoot(LevelAccessor world, RandomSource rand, BlockPos oPos, BlockPos pos, float length, float angle, float tilt, BlockStateProvider rootBlock, BlockStateProvider oreBlock) {
        BlockPos dest = FeatureLogic.translate(pos, length, angle, tilt);
        int limit = 6;
        if (oPos.m_123341_() + limit < dest.m_123341_()) {
            dest = new BlockPos(oPos.m_123341_() + limit, dest.m_123342_(), dest.m_123343_());
        }
        if (oPos.m_123341_() - limit > dest.m_123341_()) {
            dest = new BlockPos(oPos.m_123341_() - limit, dest.m_123342_(), dest.m_123343_());
        }
        if (oPos.m_123343_() + limit < dest.m_123343_()) {
            dest = new BlockPos(dest.m_123341_(), dest.m_123342_(), oPos.m_123343_() + limit);
        }
        if (oPos.m_123343_() - limit > dest.m_123343_()) {
            dest = new BlockPos(dest.m_123341_(), dest.m_123342_(), oPos.m_123343_() - limit);
        }
        if (world.m_8055_(dest).m_60734_() != Blocks.f_50069_) {
            return false;
        }
        FeaturePlacers.traceRoot((LevelSimulatedReader)world, (checkedPos, rootPlacement) -> world.m_7731_(checkedPos, rootPlacement, 3), rand, rootBlock, new VoxelBresenhamIterator(pos, dest));
        if (length > 8.0f && rand.m_188503_(3) > 0) {
            BlockPos nextSrc = FeatureLogic.translate(pos, length / 2.0f, angle, tilt);
            float nextAngle = (angle + 0.25f + rand.m_188501_() * 0.5f) % 1.0f;
            float nextTilt = 0.6f + rand.m_188501_() * 0.3f;
            this.drawRoot(world, rand, oPos, nextSrc, length / 2.0f, nextAngle, nextTilt, rootBlock, oreBlock);
        }
        if (length > 6.0f && rand.m_188503_(4) == 0) {
            BlockPos ballSrc = FeatureLogic.translate(pos, length / 2.0f, angle, tilt);
            BlockPos ballDest = FeatureLogic.translate(ballSrc, 1.5, (angle + 0.5f) % 1.0f, 0.75);
            this.placeRootBlock(world, ballSrc, oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballSrc.m_123341_(), ballSrc.m_123342_(), ballDest.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballDest.m_123341_(), ballSrc.m_123342_(), ballSrc.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballSrc.m_123341_(), ballSrc.m_123342_(), ballDest.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballSrc.m_123341_(), ballDest.m_123342_(), ballSrc.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballSrc.m_123341_(), ballDest.m_123342_(), ballDest.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballDest.m_123341_(), ballDest.m_123342_(), ballSrc.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, ballDest, oreBlock, rand);
        }
        return true;
    }

    protected boolean placeRootBlock(LevelAccessor world, BlockPos pos, BlockStateProvider state, RandomSource random) {
        return FeatureLogic.canRootGrowIn((LevelSimulatedReader)world, pos) && world.m_7731_(pos, state.m_213972_(random, pos), 3);
    }
}

