/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.inventory.slot;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TFConfig;
import twilightforest.advancements.TFAdvancements;
import twilightforest.inventory.UncraftingContainer;
import twilightforest.inventory.UncraftingMenu;
import twilightforest.item.recipe.UncraftingRecipe;

public class UncraftingSlot
extends Slot {
    protected final Player player;
    protected final Container inputSlot;
    protected final UncraftingContainer uncraftingMatrix;
    protected final Container assemblyMatrix;

    public UncraftingSlot(Player player, Container inputSlot, UncraftingContainer uncraftingMatrix, Container assemblyMatrix, int slotNum, int x, int y) {
        super((Container)uncraftingMatrix, slotNum, x, y);
        this.player = player;
        this.inputSlot = inputSlot;
        this.uncraftingMatrix = uncraftingMatrix;
        this.assemblyMatrix = assemblyMatrix;
    }

    public boolean m_5857_(ItemStack stack) {
        return false;
    }

    public boolean m_8010_(Player player) {
        if (!this.assemblyMatrix.m_7983_()) {
            return false;
        }
        if (UncraftingMenu.isMarked(this.m_7993_())) {
            return false;
        }
        if (((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.get()).booleanValue() && !(this.uncraftingMatrix.menu.storedGhostRecipe instanceof UncraftingRecipe)) {
            return false;
        }
        return this.uncraftingMatrix.uncraftingCost <= player.f_36078_ || player.m_150110_().f_35937_;
    }

    public void m_142406_(Player player, ItemStack stack) {
        if (this.uncraftingMatrix.uncraftingCost > 0) {
            this.player.m_6749_(-this.uncraftingMatrix.uncraftingCost);
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack transferStack = this.uncraftingMatrix.m_8020_(i);
            if (transferStack.m_41619_() || UncraftingMenu.isMarked(transferStack)) continue;
            this.assemblyMatrix.m_6836_(i, transferStack.m_41777_());
        }
        ItemStack inputStack = this.inputSlot.m_8020_(0);
        if (!inputStack.m_41619_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer server = (ServerPlayer)player;
                TFAdvancements.UNCRAFT_ITEM.trigger(server, inputStack);
            }
            this.inputSlot.m_7407_(0, this.uncraftingMatrix.numberOfInputItems);
        }
        super.m_142406_(player, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6659_() {
        return false;
    }
}

