/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.util.TriConsumer;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFMobEffects;
import twilightforest.init.TFSounds;
import twilightforest.init.custom.Restrictions;
import twilightforest.util.Restriction;
import twilightforest.world.components.structures.util.StructureHints;

public record Enforcement(TriConsumer<Player, ServerLevel, Restriction> consumer) {
    public static final ResourceKey<Registry<Enforcement>> ENFORCEMENT_KEY = ResourceKey.m_135788_((ResourceLocation)TwilightForestMod.prefix("enforcement"));
    public static final DeferredRegister<Enforcement> ENFORCEMENTS = DeferredRegister.create(ENFORCEMENT_KEY, (String)"twilightforest");
    public static final Supplier<IForgeRegistry<Enforcement>> ENFORCEMENT_REGISTRY = ENFORCEMENTS.makeRegistry(RegistryBuilder::new);
    public static final RegistryObject<Enforcement> DARKNESS = ENFORCEMENTS.register("darkness", () -> new Enforcement((TriConsumer<Player, ServerLevel, Restriction>)((TriConsumer)(player, level, restriction) -> {
        if (player.f_19797_ % 60 == 0) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 200, (int)restriction.multiplier(), false, true));
        }
    })));
    public static final RegistryObject<Enforcement> HUNGER = ENFORCEMENTS.register("hunger", () -> new Enforcement((TriConsumer<Player, ServerLevel, Restriction>)((TriConsumer)(player, level, restriction) -> {
        if (player.f_19797_ % 60 == 0) {
            MobEffectInstance currentHunger = player.m_21124_(MobEffects.f_19612_);
            int hungerLevel = currentHunger != null ? currentHunger.m_19564_() + (int)restriction.multiplier() : (int)restriction.multiplier();
            player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100, hungerLevel, false, true));
        }
    })));
    public static final RegistryObject<Enforcement> FIRE = ENFORCEMENTS.register("fire", () -> new Enforcement((TriConsumer<Player, ServerLevel, Restriction>)((TriConsumer)(player, level, restriction) -> {
        if (player.f_19797_ % 60 == 0) {
            player.m_20254_((int)restriction.multiplier());
        }
    })));
    public static final RegistryObject<Enforcement> FROST = ENFORCEMENTS.register("frost", () -> new Enforcement((TriConsumer<Player, ServerLevel, Restriction>)((TriConsumer)(player, level, restriction) -> {
        if (player.f_19797_ % 60 == 0) {
            player.m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), 100, (int)restriction.multiplier(), false, true));
        }
    })));
    public static final RegistryObject<Enforcement> ACID_RAIN = ENFORCEMENTS.register("acid_rain", () -> new Enforcement((TriConsumer<Player, ServerLevel, Restriction>)((TriConsumer)(player, level, restriction) -> {
        if (player.f_19797_ % 5 == 0 && player.m_6469_(TFDamageTypes.getDamageSource((Level)level, TFDamageTypes.ACID_RAIN, new EntityType[0]), restriction.multiplier())) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)TFSounds.ACID_RAIN_BURNS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    })));

    public static void enforceBiomeProgression(Player player, ServerLevel level) {
        Restrictions.getRestrictionForBiome((Biome)level.m_204166_(player.m_20183_()).m_203334_(), (Entity)player).ifPresent(restriction -> {
            Enforcement enforcement = (Enforcement)ENFORCEMENT_REGISTRY.get().getValue(restriction.enforcement().m_135782_());
            if (enforcement != null) {
                enforcement.consumer().accept((Object)player, (Object)level, restriction);
                if (restriction.hintStructureKey() != null) {
                    StructureHints.tryHintForStructure(player, level, restriction.hintStructureKey());
                }
            }
        });
    }
}

