/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.heightproviders.BiasedToBottomHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import twilightforest.TwilightForestMod;
import twilightforest.world.components.TFCavesCarver;

@Mod.EventBusSubscriber(modid="twilightforest", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TFCaveCarvers {
    public static final TFCavesCarver TFCAVES = new TFCavesCarver((Codec<CaveCarverConfiguration>)CaveCarverConfiguration.f_159154_, false);
    public static final TFCavesCarver HIGHLANDCAVES = new TFCavesCarver((Codec<CaveCarverConfiguration>)CaveCarverConfiguration.f_159154_, true);
    public static final ResourceKey<ConfiguredWorldCarver<?>> TFCAVES_CONFIGURED = TFCaveCarvers.registerKey("tf_caves");
    public static final ResourceKey<ConfiguredWorldCarver<?>> HIGHLANDCAVES_CONFIGURED = TFCaveCarvers.registerKey("highland_caves");

    @SubscribeEvent
    public static void register(RegisterEvent evt) {
        if (Objects.equals(evt.getForgeRegistry(), ForgeRegistries.WORLD_CARVERS)) {
            evt.register(ForgeRegistries.Keys.WORLD_CARVERS, helper -> helper.register(TwilightForestMod.prefix("tf_caves"), (Object)TFCAVES));
            evt.register(ForgeRegistries.Keys.WORLD_CARVERS, helper -> helper.register(TwilightForestMod.prefix("highland_caves"), (Object)HIGHLANDCAVES));
        }
    }

    private static ResourceKey<ConfiguredWorldCarver<?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257003_, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstapContext<ConfiguredWorldCarver<?>> context) {
        HolderGetter blocks = context.m_255420_(Registries.f_256747_);
        context.m_255272_(TFCAVES_CONFIGURED, (Object)TFCAVES.m_65063_((CarverConfiguration)new CaveCarverConfiguration(0.1f, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)5), (VerticalAnchor)VerticalAnchor.m_158922_((int)-8)), (FloatProvider)ConstantFloat.m_146458_((float)0.6f), VerticalAnchor.m_158921_(), (HolderSet)blocks.m_254956_(BlockTags.f_215820_), (FloatProvider)ConstantFloat.m_146458_((float)1.0f), (FloatProvider)ConstantFloat.m_146458_((float)1.0f), (FloatProvider)ConstantFloat.m_146458_((float)-0.7f))));
        context.m_255272_(HIGHLANDCAVES_CONFIGURED, (Object)HIGHLANDCAVES.m_65063_((CarverConfiguration)new CaveCarverConfiguration(0.1f, (HeightProvider)BiasedToBottomHeight.m_161931_((VerticalAnchor)VerticalAnchor.m_158930_((int)5), (VerticalAnchor)VerticalAnchor.m_158922_((int)65), (int)48), (FloatProvider)ConstantFloat.m_146458_((float)0.75f), VerticalAnchor.m_158921_(), (HolderSet)blocks.m_254956_(BlockTags.f_215820_), (FloatProvider)ConstantFloat.m_146458_((float)1.0f), (FloatProvider)ConstantFloat.m_146458_((float)1.0f), (FloatProvider)ConstantFloat.m_146458_((float)-0.7f))));
    }
}

