/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import twilightforest.entity.projectile.NatureBolt;
import twilightforest.init.TFSounds;

public class SkeletonDruid
extends AbstractSkeleton {
    private RangedAttackGoal rangedAttackGoal;
    private static final UUID SPEED_MODIFIER_BABY_UUID = UUID.fromString("3F508BEA-92F5-47B3-BCA2-B0FA84860574");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_UUID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(SkeletonDruid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SkeletonDruid(EntityType<? extends SkeletonDruid> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.25, 60, 5.0f);
        this.f_21345_.m_25352_(4, (Goal)this.rangedAttackGoal);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_BABY_ID, (Object)false);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.SKELETON_DRUID_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.SKELETON_DRUID_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.SKELETON_DRUID_DEATH.get();
    }

    protected SoundEvent m_7878_() {
        return (SoundEvent)TFSounds.SKELETON_DRUID_STEP.get();
    }

    public void m_32164_() {
        if (!this.m_9236_().m_5776_()) {
            this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
            if (this.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof HoeItem) {
                this.f_21345_.m_25352_(4, (Goal)this.rangedAttackGoal);
            } else {
                super.m_32164_();
            }
        } else {
            super.m_32164_();
        }
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        if (this.m_6162_()) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42398_));
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42434_));
        }
    }

    public void m_6504_(LivingEntity attackTarget, float extraDamage) {
        if (this.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof HoeItem) {
            NatureBolt natureBolt = new NatureBolt(this.m_9236_(), (LivingEntity)this);
            this.m_5496_((SoundEvent)TFSounds.SKELETON_DRUID_SHOOT.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            double tx = attackTarget.m_20185_() - this.m_20185_();
            double ty = attackTarget.m_20186_() + (double)attackTarget.m_20192_() - 2.7 - this.m_20186_();
            double tz = attackTarget.m_20189_() - this.m_20189_();
            float heightOffset = Mth.m_14116_((float)((float)(tx * tx + tz * tz))) * 0.2f;
            natureBolt.m_6686_(tx, ty + (double)heightOffset, tz, 0.6f, 6.0f);
            this.m_9236_().m_7967_((Entity)natureBolt);
        } else if (!this.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42398_)) {
            super.m_6504_(attackTarget, extraDamage);
        }
    }

    public static boolean checkDruidSpawnRules(EntityType<? extends SkeletonDruid> entity, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_46791_() != Difficulty.PEACEFUL && SkeletonDruid.isValidLightLevel(world, pos, random) && SkeletonDruid.m_217057_(entity, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isValidLightLevel(LevelAccessor accessor, BlockPos pos, RandomSource random) {
        if (accessor.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        return accessor.m_46803_(pos) <= random.m_188503_(12);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsBaby", this.m_6162_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_6863_(compound.m_128471_("IsBaby"));
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(DATA_BABY_ID);
    }

    public int m_213860_() {
        if (this.m_6162_()) {
            this.f_21364_ = (int)((float)this.f_21364_ * 2.5f);
        }
        return super.m_213860_();
    }

    public void m_6863_(boolean shouldBaby) {
        this.m_20088_().m_135381_(DATA_BABY_ID, (Object)shouldBaby);
        if (!this.m_9236_().m_5776_()) {
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            attributeinstance.m_22130_(SPEED_MODIFIER_BABY);
            if (shouldBaby) {
                attributeinstance.m_22118_(SPEED_MODIFIER_BABY);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DATA_BABY_ID.equals(dataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    public double m_6049_() {
        return this.m_6162_() ? -0.35 : -0.6;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? 0.93f : super.m_6431_(pose, size);
    }
}

