/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PiglinHeadModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.LightableBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;

public class SkullCandleTileEntityRenderer<T extends SkullCandleBlockEntity>
implements BlockEntityRenderer<T> {
    private final Map<SkullBlock.Type, SkullModelBase> modelByType;
    public static final Map<SkullBlock.Type, ResourceLocation> SKIN_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(SkullBlock.Types.SKELETON, new ResourceLocation("textures/entity/skeleton/skeleton.png"));
        map.put(SkullBlock.Types.WITHER_SKELETON, new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
        map.put(SkullBlock.Types.ZOMBIE, new ResourceLocation("textures/entity/zombie/zombie.png"));
        map.put(SkullBlock.Types.CREEPER, new ResourceLocation("textures/entity/creeper/creeper.png"));
        map.put(SkullBlock.Types.PIGLIN, new ResourceLocation("textures/entity/piglin/piglin.png"));
        map.put(SkullBlock.Types.PLAYER, DefaultPlayerSkin.m_118626_());
    });

    public static Map<SkullBlock.Type, SkullModelBase> createSkullRenderers(EntityModelSet set) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)SkullBlock.Types.SKELETON, (Object)new SkullModel(set.m_171103_(ModelLayers.f_171240_)));
        map.put((Object)SkullBlock.Types.WITHER_SKELETON, (Object)new SkullModel(set.m_171103_(ModelLayers.f_171219_)));
        map.put((Object)SkullBlock.Types.PLAYER, (Object)new SkullModel(set.m_171103_(ModelLayers.f_171163_)));
        map.put((Object)SkullBlock.Types.ZOMBIE, (Object)new SkullModel(set.m_171103_(ModelLayers.f_171224_)));
        map.put((Object)SkullBlock.Types.CREEPER, (Object)new SkullModel(set.m_171103_(ModelLayers.f_171130_)));
        map.put((Object)SkullBlock.Types.PIGLIN, (Object)new PiglinHeadModel(set.m_171103_(ModelLayers.f_260668_)));
        return map.build();
    }

    public SkullCandleTileEntityRenderer(BlockEntityRendererProvider.Context renderer) {
        this.modelByType = SkullCandleTileEntityRenderer.createSkullRenderers(renderer.m_173585_());
    }

    public void render(SkullCandleBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        float animationTime = entity.m_261082_(partialTicks);
        BlockState state = entity.m_58900_();
        boolean wallSkull = state.m_60734_() instanceof WallSkullCandleBlock;
        Direction direction = wallSkull ? (Direction)state.m_61143_((Property)WallSkullCandleBlock.FACING) : null;
        int rotation = wallSkull ? RotationSegment.m_245225_((Direction)direction.m_122424_()) : (Integer)state.m_61143_((Property)SkullCandleBlock.ROTATION);
        float rotDegrees = RotationSegment.m_245107_((int)rotation);
        SkullBlock.Type type = ((AbstractSkullCandleBlock)state.m_60734_()).getType();
        SkullModelBase base = this.modelByType.get(type);
        RenderType rendertype = SkullCandleTileEntityRenderer.getRenderType(type, entity.m_59779_());
        SkullCandleTileEntityRenderer.renderSkull(direction, rotDegrees, animationTime, stack, buffer, light, base, rendertype);
        if (direction != null) {
            stack.m_252880_((float)(-direction.m_122429_()) * 0.25f, 0.75f, (float)(-direction.m_122431_()) * 0.25f);
        } else {
            stack.m_252880_(0.0f, 0.45f, 0.0f);
        }
        Minecraft.m_91087_().m_91289_().m_110912_((BlockState)((BlockState)AbstractSkullCandleBlock.candleColorToCandle(AbstractSkullCandleBlock.CandleColors.colorFromInt(entity.getCandleColor())).m_49966_().m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(Math.max(1, entity.getCandleAmount())))).m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(state.m_61143_((Property)AbstractSkullCandleBlock.LIGHTING) == LightableBlock.Lighting.NORMAL)), stack, buffer, light, overlay);
    }

    public static void renderSkull(@Nullable Direction direction, float pYRot, float animationTime, PoseStack stack, MultiBufferSource buffer, int light, SkullModelBase base, RenderType type) {
        stack.m_85836_();
        if (direction == null) {
            stack.m_252880_(0.5f, 0.0f, 0.5f);
        } else {
            stack.m_252880_(0.5f - (float)direction.m_122429_() * 0.25f, 0.25f, 0.5f - (float)direction.m_122431_() * 0.25f);
        }
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer consumer = buffer.m_6299_(type);
        base.m_6251_(animationTime, pYRot, 0.0f);
        base.m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    public static RenderType getRenderType(SkullBlock.Type type, @Nullable GameProfile profile) {
        ResourceLocation resourcelocation = SKIN_BY_TYPE.get(type);
        if (type == SkullBlock.Types.PLAYER && profile != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            Map map = minecraft.m_91109_().m_118815_(profile);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.m_110473_((ResourceLocation)minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.m_110458_((ResourceLocation)DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)profile)));
        }
        return RenderType.m_110464_((ResourceLocation)resourcelocation);
    }
}

