/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.client.MissingAdvancementToast;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;
import twilightforest.network.MissingAdvancementToastPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.LandmarkUtil;
import twilightforest.util.PlayerHelper;
import twilightforest.world.NoReturnTeleporter;
import twilightforest.world.TFTeleporter;
import twilightforest.world.registration.TFGenerationSettings;

public class TFPortalBlock
extends HalfTransparentBlock
implements LiquidBlockContainer {
    public static final BooleanProperty DISALLOW_RETURN = BooleanProperty.m_61465_((String)"is_one_way");
    private static final VoxelShape AABB = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0));
    private static ResourceKey<Level> cachedOriginDimension;
    public static final Component PORTAL_UNWORTHY;
    private static final int MIN_PORTAL_SIZE = 4;
    private static final HashSet<ServerPlayer> playersNotified;

    public TFPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DISALLOW_RETURN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DISALLOW_RETURN});
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    @Deprecated
    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)DISALLOW_RETURN) != false ? AABB : Shapes.m_83040_();
    }

    public FluidState m_5888_(BlockState state) {
        return Fluids.f_76193_.m_75953_(1, false);
    }

    public boolean tryToCreatePortal(Level level, BlockPos pos, ItemEntity catalyst, @Nullable Player player) {
        BlockState state = level.m_8055_(pos);
        if (this.canFormPortal(state) && level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos, Direction.UP)) {
            HashMap<BlockPos, Boolean> blocksChecked = new HashMap<BlockPos, Boolean>();
            blocksChecked.put(pos, true);
            MutableInt size = new MutableInt(0);
            if (TFPortalBlock.recursivelyValidatePortal(level, pos, blocksChecked, size, state) && size.intValue() >= 4) {
                boolean checkProgression;
                if (((Boolean)TFConfig.COMMON_CONFIG.checkPortalDestination.get()).booleanValue() && !TFTeleporter.isSafeAround(level, pos, (Entity)catalyst, checkProgression = LandmarkUtil.isProgressionEnforced(catalyst.m_9236_()))) {
                    if (player != null) {
                        player.m_5661_((Component)Component.m_237115_((String)"misc.twilightforest.portal_unsafe"), true);
                    }
                    return false;
                }
                catalyst.m_32055_().m_41774_(1);
                TFPortalBlock.causeLightning(level, pos, (Boolean)TFConfig.COMMON_CONFIG.portalLightning.get());
                for (Map.Entry checkedPos : blocksChecked.entrySet()) {
                    if (!((Boolean)checkedPos.getValue()).booleanValue()) continue;
                    level.m_7731_((BlockPos)checkedPos.getKey(), ((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).m_49966_(), 2);
                }
                return true;
            }
        }
        return false;
    }

    public boolean canFormPortal(BlockState state) {
        return state.m_204336_(BlockTagGenerator.PORTAL_POOL) || state.m_60734_() == this && (Boolean)state.m_61143_((Property)DISALLOW_RETURN) != false;
    }

    private static void causeLightning(Level level, BlockPos pos, boolean fake) {
        LightningBolt bolt = new LightningBolt(EntityType.f_20465_, level);
        bolt.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        bolt.m_20874_(fake);
        level.m_7967_((Entity)bolt);
        if (fake && level instanceof ServerLevel) {
            double range = 3.0;
            List list = level.m_45976_(Entity.class, new AABB(pos).m_82400_(range));
            for (Entity victim : list) {
                if (ForgeEventFactory.onEntityStruckByLightning((Entity)victim, (LightningBolt)bolt)) continue;
                victim.m_8038_((ServerLevel)level, bolt);
            }
        }
    }

    public static boolean recursivelyValidatePortal(Level level, BlockPos pos, Map<BlockPos, Boolean> blocksChecked, MutableInt portalSize, BlockState poolBlock) {
        if (portalSize.incrementAndGet() > (Integer)TFConfig.COMMON_CONFIG.maxPortalSize.get()) {
            return false;
        }
        boolean isPoolProbablyEnclosed = true;
        for (int i = 0; i < 4 && portalSize.intValue() <= (Integer)TFConfig.COMMON_CONFIG.maxPortalSize.get(); ++i) {
            BlockPos positionCheck = pos.m_121945_(Direction.m_122407_((int)i));
            if (blocksChecked.containsKey(positionCheck)) continue;
            BlockState state = level.m_8055_(positionCheck);
            if (state == poolBlock && level.m_8055_(positionCheck.m_7495_()).m_60783_((BlockGetter)level, pos, Direction.UP)) {
                blocksChecked.put(positionCheck, true);
                if (!isPoolProbablyEnclosed) continue;
                isPoolProbablyEnclosed = TFPortalBlock.recursivelyValidatePortal(level, positionCheck, blocksChecked, portalSize, poolBlock);
                continue;
            }
            if (TFPortalBlock.isGrassOrDirt(state) && TFPortalBlock.isNatureBlock(level.m_8055_(positionCheck.m_7494_()))) {
                blocksChecked.put(positionCheck, false);
                continue;
            }
            return false;
        }
        return isPoolProbablyEnclosed;
    }

    private static boolean isNatureBlock(BlockState state) {
        return state.m_204336_(BlockTagGenerator.PORTAL_DECO);
    }

    private static boolean isGrassOrDirt(BlockState state) {
        return state.m_204336_(BlockTagGenerator.PORTAL_EDGE);
    }

    @Deprecated
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean good = level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos, Direction.UP);
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (!good) break;
            BlockState neighboringState = level.m_8055_(pos.m_121945_(facing));
            good = TFPortalBlock.isGrassOrDirt(neighboringState) || neighboringState == state;
        }
        if (!good) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (state == this.m_49966_()) {
            Advancement requirement;
            ServerPlayer player;
            if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).m_7500_() && !player.m_5833_() && TFConfig.getPortalLockingAdvancement((Player)player) != null && (requirement = PlayerHelper.getAdvancement((Player)player, Objects.requireNonNull(TFConfig.getPortalLockingAdvancement((Player)player)))) != null && !PlayerHelper.doesPlayerHaveRequiredAdvancement((Player)player, requirement)) {
                player.m_5661_(PORTAL_UNWORTHY, true);
                if (!TFPortalBlock.isPlayerNotifiedOfRequirement(player)) {
                    DisplayInfo info = requirement.m_138320_();
                    TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), info == null ? MissingAdvancementToast.FALLBACK : new MissingAdvancementToastPacket(info.m_14977_(), info.m_14990_()));
                    TFPortalBlock.playerNotifiedOfRequirement(player);
                }
                return;
            }
            TFPortalBlock.attemptSendEntity(entity, false, true);
        }
    }

    public static boolean isPlayerNotifiedOfRequirement(ServerPlayer player) {
        return playersNotified.contains(player);
    }

    public static void playerNotifiedOfRequirement(ServerPlayer player) {
        playersNotified.add(player);
    }

    private static ResourceKey<Level> getDestination(Entity entity) {
        if (cachedOriginDimension == null) {
            cachedOriginDimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation((String)TFConfig.COMMON_CONFIG.originDimension.get()));
        }
        return !entity.m_20193_().m_46472_().m_135782_().equals((Object)TFGenerationSettings.DIMENSION) ? TFGenerationSettings.DIMENSION_KEY : cachedOriginDimension;
    }

    public static void attemptSendEntity(Entity entity, boolean forcedEntry, boolean makeReturnPortal) {
        if (!entity.m_6084_() || entity.m_9236_().m_5776_()) {
            return;
        }
        if (entity.m_20159_() || entity.m_20160_() || !entity.m_6072_()) {
            return;
        }
        ResourceKey<Level> destination = TFPortalBlock.getDestination(entity);
        ServerLevel serverWorld = entity.m_20193_().m_7654_().m_129880_(destination);
        if (serverWorld == null) {
            return;
        }
        entity.changeDimension(serverWorld, (ITeleporter)(makeReturnPortal ? new TFTeleporter(forcedEntry) : new NoReturnTeleporter()));
        if (destination == TFGenerationSettings.DIMENSION_KEY && entity instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)entity;
            if (forcedEntry) {
                playerMP.m_9158_(destination, playerMP.m_20183_(), playerMP.m_146908_(), true, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        int random = rand.m_188503_(100);
        if (((Boolean)state.m_61143_((Property)DISALLOW_RETURN)).booleanValue() && random < 80) {
            return;
        }
        if (random == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)TFSounds.PORTAL_WHOOSH.get(), SoundSource.BLOCKS, 0.5f, rand.m_188501_() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double xPos = (float)pos.m_123341_() + rand.m_188501_();
            double yPos = (double)pos.m_123342_() + 1.0;
            double zPos = (float)pos.m_123343_() + rand.m_188501_();
            double xSpeed = ((double)rand.m_188501_() - 0.5) * 0.5;
            double ySpeed = rand.m_188501_();
            double zSpeed = ((double)rand.m_188501_() - 0.5) * 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
        }
    }

    public boolean m_6044_(BlockGetter getter, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor accessor, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    static {
        PORTAL_UNWORTHY = Component.m_237115_((String)"misc.twilightforest.portal_unworthy");
        playersNotified = new HashSet();
    }
}

