/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFParticleType;

public interface LightableBlock {
    public static final EnumProperty<Lighting> LIGHTING = EnumProperty.m_61587_((String)"lighting", Lighting.class);

    default public InteractionResult lightCandles(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_150110_().f_35938_ && player.m_21120_(hand).m_41619_() && state.m_61143_(LIGHTING) != Lighting.NONE) {
            this.extinguish(player, state, (LevelAccessor)level, pos);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (this.canBeLit(state)) {
            if (player.m_21120_(hand).m_150930_(Items.f_42409_)) {
                this.setLit((LevelAccessor)level, state, pos, true);
                level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(hand).m_41622_(1, (LivingEntity)player, res -> res.m_21190_(hand));
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (player.m_21120_(hand).m_150930_(Items.f_42613_)) {
                this.setLit((LevelAccessor)level, state, pos, true);
                level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(hand).m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    default public void lightCandlesWithProjectile(Level level, BlockState state, BlockHitResult result, Projectile projectile) {
        if (!level.m_5776_() && projectile.m_6060_() && this.canBeLit(state)) {
            this.setLit((LevelAccessor)level, state, result.m_82425_(), true);
        }
    }

    default public boolean canBeLit(BlockState state) {
        return state.m_61143_(LIGHTING) == Lighting.NONE;
    }

    public Iterable<Vec3> getParticleOffsets(BlockState var1, LevelAccessor var2, BlockPos var3);

    default public void addParticlesAndSound(Level level, BlockPos pos, double xFraction, double yFraction, double zFraction, RandomSource rand, boolean ominous) {
        this.addParticlesAndSound(level, (double)pos.m_123341_() + xFraction, (double)pos.m_123342_() + yFraction, (double)pos.m_123343_() + zFraction, rand, ominous);
    }

    default public void addParticlesAndSound(Level level, double x, double y, double z, RandomSource rand, boolean ominous) {
        float var3 = rand.m_188501_();
        if (var3 < 0.3f) {
            if (!ominous) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
            }
            if (var3 < 0.17f) {
                level.m_7785_(x + 0.5, y + 0.5, z + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + rand.m_188501_(), rand.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        level.m_7106_((ParticleOptions)(ominous ? (ParticleOptions)TFParticleType.OMINOUS_FLAME.get() : ParticleTypes.f_175834_), x, y, z, 0.0, 0.0, 0.0);
    }

    default public void addParticlesAndSound(Level level, Vec3 vec, RandomSource rand, boolean ominous) {
        float var3 = rand.m_188501_();
        if (var3 < 0.3f) {
            if (!ominous) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 0.0, 0.0, 0.0);
            }
            if (var3 < 0.17f) {
                level.m_7785_(vec.m_7096_() + 0.5, vec.m_7098_() + 0.5, vec.m_7094_() + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + rand.m_188501_(), rand.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        level.m_7106_((ParticleOptions)(ominous ? (ParticleOptions)TFParticleType.OMINOUS_FLAME.get() : ParticleTypes.f_175834_), vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
    }

    default public void extinguish(@Nullable Player player, BlockState state, LevelAccessor accessor, BlockPos pos) {
        this.setLit(accessor, state, pos, false);
        Block block = state.m_60734_();
        if (block instanceof LightableBlock) {
            LightableBlock lightableBlock = (LightableBlock)block;
            lightableBlock.getParticleOffsets(state, accessor, pos).forEach(vec3 -> accessor.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + vec3.f_82479_, (double)pos.m_123342_() + vec3.f_82480_, (double)pos.m_123343_() + vec3.f_82481_, 0.0, 0.025, 0.0));
        }
        accessor.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
        accessor.m_142346_((Entity)player, GameEvent.f_157792_, pos);
    }

    default public void setLit(LevelAccessor accessor, BlockState state, BlockPos pos, boolean lit) {
        accessor.m_7731_(pos, (BlockState)state.m_61124_(LIGHTING, (Comparable)((Object)(lit ? Lighting.NORMAL : Lighting.NONE))), 11);
    }

    public static enum Lighting implements StringRepresentable
    {
        NONE,
        NORMAL,
        OMINOUS;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

