/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.config;

import io.github.lightman314.lightmanscurrency.api.config.SyncedConfigFile;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class SPacketSyncConfig
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketSyncConfig> HANDLER = new H();
    private final ResourceLocation configID;
    private final Map<String, String> data;

    public SPacketSyncConfig(@Nonnull ResourceLocation configID, @Nonnull Map<String, String> data) {
        this.configID = configID;
        this.data = data;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130085_(this.configID);
        buffer.writeInt(this.data.size());
        this.data.forEach((id, dat) -> {
            buffer.m_130070_(id);
            buffer.m_130070_(dat);
        });
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncConfig> {
        private H() {
        }

        @Override
        @Nonnull
        public SPacketSyncConfig decode(@Nonnull FriendlyByteBuf buffer) {
            ResourceLocation configID = buffer.m_130281_();
            int count = buffer.readInt();
            HashMap<String, String> data = new HashMap<String, String>();
            for (int i = 0; i < count; ++i) {
                String id = buffer.m_130277_();
                String dat = buffer.m_130277_();
                data.put(id, dat);
            }
            return new SPacketSyncConfig(configID, data);
        }

        @Override
        protected void handle(@Nonnull SPacketSyncConfig message, @Nullable ServerPlayer sender) {
            SyncedConfigFile.handleSyncData(message.configID, message.data);
        }
    }
}

