/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.mixinsupport.create;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WalletInventoryWrapper
extends Inventory {
    public static MoneyView expectedCost = MoneyView.empty();
    private final Inventory inventory;
    private final List<Pair<Integer, ItemStack>> paymentItemsInInventory = new ArrayList<Pair<Integer, ItemStack>>();
    private final List<ItemStack> paymentItems = new ArrayList<ItemStack>();

    public WalletInventoryWrapper(Inventory inventory, IWalletHandler walletHandler, InventorySummary paymentItems) {
        super(inventory.f_35978_);
        this.inventory = inventory;
        this.setupPaymentItems(walletHandler, paymentItems);
    }

    private void setupPaymentItems(IWalletHandler walletHandler, InventorySummary paymentItems) {
        ItemStack wallet = walletHandler.getWallet();
        SimpleContainer walletContents = WalletItem.getWalletInventory(wallet);
        MoneyStorage cost = new MoneyStorage(() -> {});
        IMoneyHandler walletMoney = MoneyAPI.API.GetContainersMoneyHandler((Container)walletContents, this.f_35978_);
        ArrayList<ItemStack> coinsToAdd = new ArrayList<ItemStack>();
        for (Object stack : paymentItems.getStacks()) {
            if (CoinAPI.API.IsCoin(((BigItemStack)stack).stack, false)) {
                int countToExtract = ((BigItemStack)stack).count;
                if ((countToExtract -= this.queryPaymentItems((BigItemStack)stack)) <= 0) continue;
                ChainData chain = CoinAPI.API.ChainDataOfCoin(((BigItemStack)stack).stack);
                cost.addValue(CoinValue.fromNumber(chain, chain.getCoreValue(((BigItemStack)stack).stack) * (long)((BigItemStack)stack).count));
                coinsToAdd.add(((BigItemStack)stack).stack.m_255036_(countToExtract));
                continue;
            }
            this.queryPaymentItems((BigItemStack)stack);
        }
        if (!cost.isEmpty()) {
            MoneyView availableFunds = walletMoney.getStoredMoney();
            for (MoneyValue val : cost.allValues()) {
                if (availableFunds.containsValue(val)) continue;
                return;
            }
            ArrayList<MoneyValue> taken = new ArrayList<MoneyValue>();
            for (MoneyValue val : cost.allValues()) {
                if (walletMoney.extractMoney(val, true).isEmpty()) {
                    walletMoney.extractMoney(val, false);
                    taken.add(val);
                    continue;
                }
                for (MoneyValue v : taken) {
                    walletMoney.insertMoney(v, false);
                }
                return;
            }
            WalletItem.putWalletInventory(wallet, (Container)walletContents);
            walletHandler.setWallet(wallet);
            this.paymentItems.addAll(coinsToAdd);
        }
    }

    private int queryPaymentItems(BigItemStack stack) {
        int foundCount = 0;
        for (int i = 0; i < this.inventory.f_35974_.size(); ++i) {
            ItemStack item = this.inventory.m_8020_(i);
            if (!item.m_150930_(stack.stack.m_41720_())) continue;
            this.paymentItemsInInventory.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)item));
            foundCount += item.m_41613_();
        }
        return foundCount;
    }

    public void clearContents() {
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)this.f_35978_);
        if (walletHandler != null) {
            ItemStack wallet = walletHandler.getWallet();
            SimpleContainer walletContents = WalletItem.getWalletInventory(wallet);
            for (ItemStack item : this.paymentItems) {
                if ((item = InventoryUtil.TryPutItemStack((Container)walletContents, item)).m_41619_()) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)this.f_35978_, (ItemStack)item);
            }
            WalletItem.putWalletInventory(wallet, (Container)walletContents);
            walletHandler.setWallet(wallet);
            return;
        }
        for (ItemStack item : this.paymentItems) {
            if (item.m_41619_()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)this.f_35978_, (ItemStack)item);
        }
    }

    public ItemStack m_8020_(int slot) {
        if (slot < this.paymentItemsInInventory.size()) {
            return (ItemStack)this.paymentItemsInInventory.get(slot).getSecond();
        }
        if ((slot -= this.paymentItemsInInventory.size()) < this.paymentItems.size()) {
            return this.paymentItems.get(slot);
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot < this.paymentItemsInInventory.size()) {
            Pair<Integer, ItemStack> pair = this.paymentItemsInInventory.get(slot);
            this.inventory.m_6836_(((Integer)pair.getFirst()).intValue(), stack);
            this.paymentItemsInInventory.set(slot, (Pair<Integer, ItemStack>)Pair.of((Object)((Integer)pair.getFirst()), (Object)stack));
            return;
        }
        if ((slot -= this.paymentItemsInInventory.size()) < this.paymentItems.size()) {
            this.paymentItems.set(slot, stack);
        } else if (!stack.m_41619_()) {
            ItemHandlerHelper.giveItemToPlayer((Player)this.f_35978_, (ItemStack)stack);
        }
    }
}

