/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.mixin.compat.create;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.mixinsupport.create.WalletInventoryWrapper;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StockTickerInteractionHandler.class}, remap=false)
public class StockTickerInteractionHandlerMixin {
    @Unique
    private static WalletInventoryWrapper wrapper;

    @Inject(at={@At(value="FIELD", target="net/createmod/catnip/data/Iterate.trueAndFalse:[Z")}, method={"interactWithShop"}, cancellable=true)
    private static void interactWithShop(Player player, Level level, BlockPos targetPos, ItemStack mainHandItem, CallbackInfo ci, @Local(name={"paymentEntries"}) InventorySummary paymentEntries) {
        ItemStack wallet;
        StockTickerInteractionHandlerMixin.clearWrapper();
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player);
        ItemStack itemStack = wallet = walletHandler == null ? ItemStack.f_41583_ : walletHandler.getWallet();
        if (!WalletItem.isWallet(wallet)) {
            return;
        }
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        for (BigItemStack stack : paymentEntries.getStacks()) {
            if (CoinAPI.API.IsCoin(stack.stack, false)) {
                map.put(stack.stack.m_41720_(), stack.count);
                continue;
            }
            return;
        }
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            ItemStack item = inventory.m_8020_(i);
            if (!map.containsKey(item.m_41720_())) continue;
            map.put(item.m_41720_(), (Integer)map.get(item.m_41720_()) - item.m_41613_());
        }
        MoneyStorage cost = new MoneyStorage(() -> {});
        for (Item coin : map.keySet()) {
            ChainData chain = CoinAPI.API.ChainDataOfCoin(coin);
            int count = (Integer)map.get(coin);
            if (count <= 0) continue;
            cost.addValue(CoinValue.fromNumber(chain, (long)count));
        }
        if (!cost.isEmpty()) {
            MoneyView available = MoneyAPI.API.GetContainersMoneyHandler((Container)WalletItem.getWalletInventory(wallet), s -> {}, IClientTracker.forServer()).getStoredMoney();
            for (MoneyValue c : cost.allValues()) {
                if (available.containsValue(c)) continue;
                player.m_6330_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(VersionUtil.modResource("create", "deny")), SoundSource.PLAYERS, 1.0f, 0.5f);
                player.m_5661_((Component)EasyText.translatable("create.stock_keeper.too_broke", new Object[0]).m_130940_(ChatFormatting.RED), true);
                ci.cancel();
                return;
            }
        }
    }

    @WrapOperation(at={@At(value="INVOKE", target="net/minecraft/world/entity/player/Player.getInventory()Lnet/minecraft/world/entity/player/Inventory;")}, method={"interactWithShop"})
    private static Inventory wrapInventory(Player player, Operation<Inventory> next, @Local(name={"paymentEntries"}) InventorySummary paymentEntries) {
        ItemStack wallet;
        if (player.m_9236_().f_46443_) {
            return (Inventory)next.call(new Object[]{player});
        }
        StockTickerInteractionHandlerMixin.clearWrapper();
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player);
        ItemStack itemStack = wallet = walletHandler == null ? ItemStack.f_41583_ : walletHandler.getWallet();
        if (!WalletItem.isWallet(wallet)) {
            return (Inventory)next.call(new Object[]{player});
        }
        for (BigItemStack stack : paymentEntries.getStacks()) {
            if (!CoinAPI.API.IsCoin(stack.stack, false)) continue;
            wrapper = new WalletInventoryWrapper((Inventory)next.call(new Object[]{player}), walletHandler, paymentEntries.copy());
            return wrapper;
        }
        return (Inventory)next.call(new Object[]{player});
    }

    @Inject(at={@At(value="RETURN")}, method={"interactWithShop"})
    private static void interactWithShop(Player player, Level level, BlockPos targetPos, ItemStack mainHandItem, CallbackInfo ci) {
        StockTickerInteractionHandlerMixin.clearWrapper();
    }

    @Unique
    private static void clearWrapper() {
        if (wrapper != null) {
            wrapper.clearContents();
            wrapper = null;
        }
    }
}

