/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.mixin;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.mixin.AbstractContainerMenuAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={InventoryMenu.class})
public abstract class InventoryMenuMixin {
    @Unique
    private Slot walletSlot = null;

    @Unique
    protected InventoryMenu self() {
        return (InventoryMenu)this;
    }

    @Accessor(value="owner")
    protected abstract Player getPlayer();

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    protected void init(Inventory inventory, boolean active, Player player, CallbackInfo callbackInfo) {
        if (LCCurios.isLoaded()) {
            return;
        }
        InventoryMenu inventoryMenu = this.self();
        if (inventoryMenu instanceof AbstractContainerMenuAccessor) {
            AbstractContainerMenuAccessor accessor = (AbstractContainerMenuAccessor)inventoryMenu;
            this.walletSlot = accessor.addCustomSlot(new WalletSlot(player, WalletCapability.getWalletContainer((Entity)player), 0, ((ScreenPosition)LCConfig.CLIENT.walletSlot.get()).x + 1, ((ScreenPosition)LCConfig.CLIENT.walletSlot.get()).y + 1));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"quickMoveStack"}, cancellable=true)
    protected void quickMoveStack(Player player, int slotIndex, CallbackInfoReturnable<ItemStack> callbackInfo) {
        Slot slot;
        if (slotIndex >= 9 && slotIndex < 45 && this.walletSlot != null && (slot = (Slot)this.self().f_38839_.get(slotIndex)).m_6657_() && WalletItem.isWallet(slot.m_7993_()) && !this.walletSlot.m_6657_()) {
            this.walletSlot.m_5852_(slot.m_7993_().m_41777_());
            slot.m_5852_(ItemStack.f_41583_);
            callbackInfo.setReturnValue((Object)ItemStack.f_41583_);
        }
    }
}

