/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.reiplugin;

import com.mojang.datafixers.util.Pair;
import dev.architectury.event.CompoundEventResult;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NotificationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.CoinChestScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.EjectionRecoveryScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.GachaMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.PlayerTradeScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.SlotMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TaxCollectorScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TicketStationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeTypes;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.items.colored.ColoredItem;
import io.github.lightman314.lightmanscurrency.common.menus.TicketStationMenu;
import io.github.lightman314.lightmanscurrency.integration.reiplugin.coin_mint.CoinMintCategory;
import io.github.lightman314.lightmanscurrency.integration.reiplugin.coin_mint.CoinMintDisplay;
import io.github.lightman314.lightmanscurrency.integration.reiplugin.coin_mint.CoinMintTransferHandler;
import io.github.lightman314.lightmanscurrency.integration.reiplugin.ticket_station.TicketStationCategory;
import io.github.lightman314.lightmanscurrency.integration.reiplugin.ticket_station.TicketStationDisplay;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@REIPluginClient
public class LCClientPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)CoinMintCategory.INSTANCE);
        registry.addWorkstations(CoinMintCategory.ID, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModBlocks.COIN_MINT.get()))});
        registry.add((DisplayCategory)TicketStationCategory.INSTANCE);
        registry.addWorkstations(TicketStationCategory.ID, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModBlocks.TICKET_STATION.get()))});
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(CoinMintRecipe.class, (RecipeType)RecipeTypes.COIN_MINT.get(), CoinMintDisplay::new);
        registry.registerRecipeFiller(TicketStationRecipe.class, (RecipeType)RecipeTypes.TICKET.get(), TicketStationDisplay::new);
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(screen -> new Rectangle(screen.getGuiLeft() + 80, screen.getGuiTop() + 21, 22, 16), MintScreen.class, new CategoryIdentifier[]{CoinMintCategory.ID});
        registry.registerClickArea(screen -> new Rectangle(screen.getGuiLeft() + 8, screen.getGuiTop() + 6, 100, 10), TicketStationScreen.class, new CategoryIdentifier[]{TicketStationCategory.ID});
        registry.registerFocusedStack((screen, mouse) -> {
            if (screen instanceof EasyMenuScreen) {
                EasyMenuScreen s = (EasyMenuScreen)screen;
                ScreenPosition mousePos = ScreenPosition.of(mouse.x, mouse.y);
                Pair item = s.getHoveredItem(mousePos);
                if (item != null && !((ItemStack)item.getFirst()).m_41619_()) {
                    return CompoundEventResult.interruptTrue((Object)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)((ItemStack)item.getFirst())));
                }
                Pair fluid = s.getHoveredFluid(mousePos);
                if (fluid != null && !((FluidStack)fluid.getFirst()).isEmpty()) {
                    FluidStack f = (FluidStack)fluid.getFirst();
                    return CompoundEventResult.interruptTrue((Object)EntryStack.of((EntryType)VanillaEntryTypes.FLUID, (Object)dev.architectury.fluid.FluidStack.create((Fluid)f.getFluid(), (long)f.getAmount(), (CompoundTag)f.getTag())));
                }
            }
            return CompoundEventResult.pass();
        });
    }

    public void registerEntries(EntryRegistry registry) {
        registry.removeEntry(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)ModItems.PREPAID_CARD.get())));
        registry.removeEntry(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)ModItems.ATM_CARD.get())));
        ArrayList<EntryStack> allCards = new ArrayList<EntryStack>();
        for (Color color : Color.values()) {
            ItemStack atmCard = new ItemStack((ItemLike)ModItems.ATM_CARD.get());
            ColoredItem.setItemColor(atmCard, color.hexColor);
            allCards.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)atmCard));
        }
        registry.addEntries(allCards);
        registry.removeEntry(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)ModItems.GACHA_BALL.get())));
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(CoinMintTransferHandler.INSTANCE);
        registry.register((TransferHandler)SimpleTransferHandler.create(TicketStationMenu.class, TicketStationCategory.ID, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 2)));
    }

    public void registerExclusionZones(ExclusionZones zones) {
        this.registerExclusionZones(zones, TraderScreen.class);
        this.registerExclusionZones(zones, SlotMachineScreen.class);
        this.registerExclusionZones(zones, GachaMachineScreen.class);
        this.registerExclusionZones(zones, TraderStorageScreen.class);
        this.registerExclusionZones(zones, ATMScreen.class);
        this.registerExclusionZones(zones, TaxCollectorScreen.class);
        this.registerExclusionZones(zones, CoinChestScreen.class);
        this.registerExclusionZones(zones, EjectionRecoveryScreen.class);
        this.registerExclusionZones(zones, PlayerTradeScreen.class);
        this.registerExclusionZones(zones, TraderInterfaceScreen.class);
        this.registerExclusionZones(zones, WalletScreen.class);
        this.registerExclusionZones(zones, WalletBankScreen.class);
        this.registerExclusionZones(zones, TeamManagerScreen.class);
        this.registerExclusionZones(zones, NotificationScreen.class);
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        registry.group(VersionUtil.lcResource("rei_groups/display_case"), (Component)LCText.REI_GROUP_DISPLAY_CASE.get(new Object[0]), this.isInBundle(ModBlocks.DISPLAY_CASE));
        registry.group(VersionUtil.lcResource("rei_groups/shelves"), (Component)LCText.REI_GROUP_SHELF.get(new Object[0]), this.isInBundle(ModBlocks.SHELF));
        registry.group(VersionUtil.lcResource("rei_groups/double_shelves"), (Component)LCText.REI_GROUP_SHELF_2x2.get(new Object[0]), this.isInBundle(ModBlocks.SHELF_2x2));
        ModBlocks.CARD_DISPLAY.forEachKey1(woodType -> registry.group(VersionUtil.lcResource(woodType.generateID("rei_groups/card_displays")), (Component)LCText.REI_GROUP_CARD_DISPLAY.get((WoodType)woodType).get(new Object[0]), this.isInBundle(ModBlocks.CARD_DISPLAY, woodType)));
        registry.group(VersionUtil.lcResource("rei_groups/vending_machine"), (Component)LCText.REI_GROUP_VENDING_MACHINE.get(new Object[0]), this.isInBundle(ModBlocks.VENDING_MACHINE));
        registry.group(VersionUtil.lcResource("rei_groups/large_vending_machine"), (Component)LCText.REI_GROUP_LARGE_VENDING_MACHINE.get(new Object[0]), this.isInBundle(ModBlocks.VENDING_MACHINE_LARGE));
        registry.group(VersionUtil.lcResource("rei_groups/freezer"), (Component)LCText.REI_GROUP_FREEZER.get(new Object[0]), this.isInBundle(ModBlocks.FREEZER));
        registry.group(VersionUtil.lcResource("rei_groups/bookshelves"), (Component)LCText.REI_GROUP_BOOKSHELF_TRADER.get(new Object[0]), this.isInBundle(ModBlocks.BOOKSHELF_TRADER));
        registry.group(VersionUtil.lcResource("rei_groups/auction_stand"), (Component)LCText.REI_GROUP_AUCTION_STAND.get(new Object[0]), this.isInBundle(ModBlocks.AUCTION_STAND));
        registry.group(VersionUtil.lcResource("rei_groups/jar_of_sus"), (Component)LCText.REI_GROUP_JAR_OF_SUS.get(new Object[0]), this.isItem((Supplier<? extends ItemLike>)ModBlocks.SUS_JAR));
        registry.group(VersionUtil.lcResource("rei_groups/atm_card"), (Component)LCText.REI_GROUP_ATM_CARD.get(new Object[0]), this.isItem((Supplier<? extends ItemLike>)ModItems.ATM_CARD));
        registry.group(VersionUtil.lcResource("rei_groups/ancient_cions"), (Component)LCText.REI_GROUP_ANCIENT_COINS.get(new Object[0]), this.isItem((Supplier<? extends ItemLike>)ModItems.COIN_ANCIENT));
        registry.group(VersionUtil.lcResource("rei_groups/gacha_machines"), (Component)LCText.REI_GROUP_GACHA_MACHINE.get(new Object[0]), this.isInBundle(ModBlocks.GACHA_MACHINE));
    }

    private <T extends EasyMenuScreen<?>> void registerExclusionZones(@Nonnull ExclusionZones zones, @Nonnull Class<T> clazz) {
        zones.register(clazz, screen -> {
            ArrayList<Rectangle> areas = new ArrayList<Rectangle>();
            ScreenArea screenArea = screen.getArea();
            for (GuiEventListener child : screen.m_6702_()) {
                ScreenArea area;
                if (!(child instanceof EasyWidget)) continue;
                EasyWidget widget = (EasyWidget)child;
                if (!widget.f_93624_ || !screenArea.isOutside(area = widget.getArea())) continue;
                areas.add(new Rectangle(area.x, area.y, area.width, area.height));
            }
            return areas;
        });
    }

    private Predicate<? extends EntryStack<?>> isItem(@Nonnull Supplier<? extends ItemLike> item) {
        return entryStack -> {
            Object patt11316$temp = entryStack.getValue();
            if (patt11316$temp instanceof ItemStack) {
                ItemStack stack = (ItemStack)patt11316$temp;
                return ((ItemLike)item.get()).m_5456_() == stack.m_41720_();
            }
            return false;
        };
    }

    private Predicate<? extends EntryStack<?>> isInBundle(@Nonnull RegistryObjectBundle<? extends ItemLike, ?> bundle) {
        return entryStack -> {
            Object patt11652$temp = entryStack.getValue();
            if (patt11652$temp instanceof ItemStack) {
                ItemStack stack = (ItemStack)patt11652$temp;
                return bundle.getAll().stream().anyMatch(i -> i.m_5456_() == stack.m_41720_());
            }
            return false;
        };
    }

    private <T> Predicate<? extends EntryStack<?>> isInBundle(@Nonnull RegistryObjectBiBundle<? extends ItemLike, T, ?> bundle, T subSection) {
        return entryStack -> {
            Object patt12041$temp = entryStack.getValue();
            if (patt12041$temp instanceof ItemStack) {
                ItemStack stack = (ItemStack)patt12041$temp;
                return bundle.getAll(subSection).stream().anyMatch(i -> i.m_5456_() == stack.m_41720_());
            }
            return false;
        };
    }
}

