/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.curios;

import io.github.lightman314.lightmanscurrency.integration.curios.LCCuriosInternal;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;

public class LCCurios {
    public static boolean isLoaded() {
        return ModList.get().isLoaded("curios");
    }

    public static boolean hasWalletSlot(@Nonnull LivingEntity entity) {
        return LCCurios.isLoaded() && LCCuriosInternal.hasWalletSlot(entity);
    }

    @Nonnull
    public static ItemStack getCuriosWalletItem(@Nonnull LivingEntity entity) {
        return LCCurios.isLoaded() ? LCCuriosInternal.getCuriosWalletItem(entity) : ItemStack.f_41583_;
    }

    @Nonnull
    public static ItemStack getVisibleCuriosWalletItem(@Nonnull LivingEntity entity) {
        return LCCurios.isLoaded() ? LCCuriosInternal.getVisibleCuriosWalletItem(entity) : ItemStack.f_41583_;
    }

    public static void setCuriosWalletItem(@Nonnull LivingEntity entity, @Nonnull ItemStack stack) {
        if (LCCurios.isLoaded()) {
            LCCuriosInternal.setCuriosWalletItem(entity, stack);
        }
    }

    public static boolean getCuriosWalletVisibility(@Nonnull LivingEntity entity) {
        return LCCurios.isLoaded() && LCCuriosInternal.getCuriosWalletVisibility(entity);
    }

    public static boolean hasItem(@Nonnull LivingEntity entity, @Nonnull Predicate<ItemStack> check) {
        return LCCurios.isLoaded() && LCCuriosInternal.hasItem(entity, check);
    }

    public static boolean hasPortableTerminal(@Nonnull LivingEntity entity) {
        return LCCurios.isLoaded() && LCCuriosInternal.hasPortableTerminal(entity);
    }

    public static boolean hasPortableATM(@Nonnull LivingEntity entity) {
        return LCCurios.isLoaded() && LCCuriosInternal.hasPortableATM(entity);
    }

    @Nullable
    public static ItemStack getRandomItem(@Nonnull LivingEntity entity, @Nonnull Predicate<ItemStack> check) {
        return LCCurios.isLoaded() ? LCCuriosInternal.getRandomItem(entity, check) : null;
    }

    @Nullable
    public static ICapabilityProvider createWalletProvider(ItemStack stack) {
        if (LCCurios.isLoaded()) {
            return LCCuriosInternal.createWalletProvider(stack);
        }
        return null;
    }
}

