/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MintRecipeBuilder
implements RecipeBuilder {
    private final Ingredient ingredient;
    private final int ingredientCount;
    private final Item result;
    private final int count;
    private int duration = 0;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    private MintRecipeBuilder(@Nonnull Ingredient ingredient, int ingredientCount, @Nonnull ItemLike result, int count) {
        this.ingredient = ingredient;
        this.ingredientCount = ingredientCount;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static MintRecipeBuilder create(@Nonnull ItemLike input, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, 1, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull ItemLike input, int inputCount, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, inputCount, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull ItemLike input, @Nonnull ItemLike result, int resultCount) {
        return MintRecipeBuilder.create(input, 1, result, resultCount);
    }

    public static MintRecipeBuilder create(@Nonnull ItemLike input, int inputCount, @Nonnull ItemLike result, int resultCount) {
        return MintRecipeBuilder.create(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), inputCount, result, resultCount);
    }

    public static MintRecipeBuilder create(@Nonnull TagKey<Item> input, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, 1, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull TagKey<Item> input, int inputCount, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, inputCount, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull TagKey<Item> input, @Nonnull ItemLike result, int resultCount) {
        return MintRecipeBuilder.create(input, 1, result, resultCount);
    }

    public static MintRecipeBuilder create(@Nonnull TagKey<Item> input, int inputCount, @Nonnull ItemLike result, int resultCount) {
        return MintRecipeBuilder.create(Ingredient.m_204132_(input), inputCount, result, resultCount);
    }

    public static MintRecipeBuilder create(@Nonnull Ingredient input, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, 1, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull Ingredient input, int inputCount, @Nonnull ItemLike result) {
        return MintRecipeBuilder.create(input, inputCount, result, 1);
    }

    public static MintRecipeBuilder create(@Nonnull Ingredient input, @Nonnull ItemLike result, int resultCount) {
        return MintRecipeBuilder.create(input, 1, result, resultCount);
    }

    public static MintRecipeBuilder create(@Nonnull Ingredient input, int inputCount, @Nonnull ItemLike result, int resultCount) {
        return new MintRecipeBuilder(input, inputCount, result, resultCount);
    }

    @Nonnull
    public MintRecipeBuilder ofDuration(int duration) {
        this.duration = duration;
        return this;
    }

    @Nonnull
    public MintRecipeBuilder unlockedBy(@Nonnull String name, @Nonnull CriterionTriggerInstance criteria) {
        this.advancement.m_138386_(name, criteria);
        return this;
    }

    @Nonnull
    public MintRecipeBuilder group(@Nullable String group) {
        return this;
    }

    @Nonnull
    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.result, this.count, this.duration, this.ingredient, this.ingredientCount, this.advancement, id.m_246208_("recipes/coin_mint/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredient defined for " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final int duration;
        private final Ingredient ingredient;
        private final int ingredientCount;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Item result, int count, int duration, Ingredient ingredient, int ingredientCount, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.duration = duration;
            this.ingredient = ingredient;
            this.ingredientCount = ingredientCount;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            if (this.ingredientCount > 1) {
                json.addProperty("count", (Number)this.ingredientCount);
            }
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.count > 1) {
                resultObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)resultObject);
            if (this.duration > 0) {
                json.addProperty("duration", (Number)this.duration);
            }
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.COIN_MINT.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

