/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.client;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IWideBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.MoneyBagBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.items.AncientCoinItem;
import io.github.lightman314.lightmanscurrency.common.items.MoneyBagItem;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.datagen.util.ColorHelper;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class LCBlockStateProvider
extends BlockStateProvider {
    private static final ResourceLocation UPGRADE_TIER_COPPER = VersionUtil.lcResource("item/upgrade_tier/copper");
    private static final ResourceLocation UPGRADE_TIER_IRON = VersionUtil.lcResource("item/upgrade_tier/iron");
    private static final ResourceLocation UPGRADE_TIER_GOLD = VersionUtil.lcResource("item/upgrade_tier/gold");
    private static final ResourceLocation UPGRADE_TIER_EMERALD = VersionUtil.lcResource("item/upgrade_tier/emerald");
    private static final ResourceLocation UPGRADE_TIER_DIAMOND = VersionUtil.lcResource("item/upgrade_tier/diamond");
    private static final ResourceLocation UPGRADE_TIER_NETHERITE = VersionUtil.lcResource("item/upgrade_tier/netherite");
    private static final ResourceLocation UPGRADE_ITEM_CAPACITY = VersionUtil.lcResource("item/item_capacity_upgrade");
    private static final ResourceLocation UPGRADE_TRADE_OFFER = VersionUtil.lcResource("item/trading_core");
    private static final ResourceLocation UPGRADE_NETWORK = VersionUtil.vanillaResource("item/ender_eye");
    private static final ResourceLocation UPGRADE_VOID = VersionUtil.vanillaResource("item/barrier");
    private static final ResourceLocation UPGRADE_SPEED = VersionUtil.vanillaResource("item/clock_00");
    private static final ResourceLocation UPGRADE_HOPPER = VersionUtil.vanillaResource("item/hopper");
    private static final ResourceLocation UPGRADE_CC_SECURITY = VersionUtil.lcResource("item/coin_chest_security_upgrade");
    private static final ResourceLocation UPGRADE_CC_BANK = VersionUtil.lcResource("item/coin_chest_bank_upgrade");
    private static final ResourceLocation UPGRADE_CC_EXCHANGE = VersionUtil.lcResource("item/coin_chest_exchange_upgrade");
    private static final ResourceLocation UPGRADE_CC_MAGNET = VersionUtil.vanillaResource("item/ender_pearl");
    private static final ResourceLocation WALLET_MODEL_BASE = WalletItem.lazyModel("wallet_base");

    public LCBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "lightmanscurrency", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerBasicItem(ModItems.COIN_COPPER);
        this.registerBasicItem(ModItems.COIN_IRON);
        this.registerBasicItem(ModItems.COIN_GOLD);
        this.registerBasicItem(ModItems.COIN_EMERALD);
        this.registerBasicItem(ModItems.COIN_DIAMOND);
        this.registerBasicItem(ModItems.COIN_NETHERITE);
        this.registerBasicItem(ModItems.COIN_CHOCOLATE_COPPER);
        this.registerBasicItem(ModItems.COIN_CHOCOLATE_IRON);
        this.registerBasicItem(ModItems.COIN_CHOCOLATE_GOLD);
        this.registerBasicItem(ModItems.COIN_CHOCOLATE_EMERALD);
        this.registerBasicItem(ModItems.COIN_CHOCOLATE_DIAMOND);
        this.registerBasicItem(ModItems.COIN_CHOCOLATE_NETHERITE);
        this.registerCoinPile(ModBlocks.COINPILE_COPPER);
        this.registerCoinPile(ModBlocks.COINPILE_IRON);
        this.registerCoinPile(ModBlocks.COINPILE_GOLD);
        this.registerCoinPile(ModBlocks.COINPILE_EMERALD);
        this.registerCoinPile(ModBlocks.COINPILE_DIAMOND);
        this.registerCoinPile(ModBlocks.COINPILE_NETHERITE);
        this.registerCoinPile(ModBlocks.COINPILE_CHOCOLATE_COPPER);
        this.registerCoinPile(ModBlocks.COINPILE_CHOCOLATE_IRON);
        this.registerCoinPile(ModBlocks.COINPILE_CHOCOLATE_GOLD);
        this.registerCoinPile(ModBlocks.COINPILE_CHOCOLATE_EMERALD);
        this.registerCoinPile(ModBlocks.COINPILE_CHOCOLATE_DIAMOND);
        this.registerCoinPile(ModBlocks.COINPILE_CHOCOLATE_NETHERITE);
        this.registerCoinBlock(ModBlocks.COINBLOCK_COPPER);
        this.registerCoinBlock(ModBlocks.COINBLOCK_IRON);
        this.registerCoinBlock(ModBlocks.COINBLOCK_GOLD);
        this.registerCoinBlock(ModBlocks.COINBLOCK_EMERALD);
        this.registerCoinBlock(ModBlocks.COINBLOCK_DIAMOND);
        this.registerCoinBlock(ModBlocks.COINBLOCK_NETHERITE);
        this.registerCoinBlock(ModBlocks.COINBLOCK_CHOCOLATE_COPPER);
        this.registerCoinBlock(ModBlocks.COINBLOCK_CHOCOLATE_IRON);
        this.registerCoinBlock(ModBlocks.COINBLOCK_CHOCOLATE_GOLD);
        this.registerCoinBlock(ModBlocks.COINBLOCK_CHOCOLATE_EMERALD);
        this.registerCoinBlock(ModBlocks.COINBLOCK_CHOCOLATE_DIAMOND);
        this.registerCoinBlock(ModBlocks.COINBLOCK_CHOCOLATE_NETHERITE);
        this.registerAncientCoin(ModItems.COIN_ANCIENT);
        this.registerBasicItem(ModItems.TRADING_CORE);
        this.registerWalletItem(ModItems.WALLET_LEATHER);
        this.registerWalletItem(ModItems.WALLET_COPPER);
        this.registerWalletItem(ModItems.WALLET_IRON);
        this.registerWalletItem(ModItems.WALLET_GOLD);
        this.registerWalletItem(ModItems.WALLET_EMERALD);
        this.registerWalletItem(ModItems.WALLET_DIAMOND);
        this.registerWalletItem(ModItems.WALLET_NETHERITE);
        this.registerWalletItem(ModItems.WALLET_NETHER_STAR);
        this.registerBasicItem(ModItems.WALLET_ENDER_DRAGON);
        this.registerTallRotatable(ModBlocks.ATM, "atm_top", "atm_bottom", "atm", true);
        this.registerLayeredItem(ModItems.ATM_CARD);
        this.registerLayeredItem(ModItems.PREPAID_CARD);
        this.registerRotatable(ModBlocks.COIN_MINT);
        this.registerRotatable(ModBlocks.CASH_REGISTER, "cash_register_modern", true);
        ModBlocks.DISPLAY_CASE.forEach((color, block) -> {
            ResourceLocation woolTexture = ColorHelper.GetWoolTextureOfColor(color);
            String modelID = this.lazyColoredID("block/display_case/", (Color)((Object)color));
            ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelID)).parent(this.lazyBlockModel("display_case/base", true))).texture("wool", woolTexture);
            this.simpleBlockWithItem((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile(VersionUtil.lcResource(modelID)));
        });
        ModBlocks.VENDING_MACHINE.forEach((color, block) -> {
            ResourceLocation interiorTexture = VersionUtil.lcResource(this.lazyColoredID("block/vending_machine/", (Color)((Object)color), "_interior"));
            ResourceLocation exteriorTexture = VersionUtil.lcResource(this.lazyColoredID("block/vending_machine/", (Color)((Object)color), "_exterior"));
            String topID = this.lazyColoredID("block/vending_machine/", (Color)((Object)color), "_top");
            String bottomID = this.lazyColoredID("block/vending_machine/", (Color)((Object)color), "_bottom");
            String itemID = this.lazyColoredID("block/vending_machine/", (Color)((Object)color), "_item");
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(topID)).parent(this.lazyBlockModel("vending_machine/base_top", true))).texture("exterior", exteriorTexture)).texture("interior", interiorTexture);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(bottomID)).parent(this.lazyBlockModel("vending_machine/base_bottom", true))).texture("exterior", exteriorTexture)).texture("interior", interiorTexture);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(itemID)).parent(this.lazyBlockModel("vending_machine/base_item", true))).texture("exterior", exteriorTexture)).texture("interior", interiorTexture);
            this.registerTallRotatable((RegistryObject<? extends Block>)block, topID, bottomID, itemID, false);
        });
        ModBlocks.VENDING_MACHINE_LARGE.forEach((color, block) -> {
            ResourceLocation interiorTexture = VersionUtil.lcResource(this.lazyColoredID("block/large_vending_machine/", (Color)((Object)color), "_interior"));
            ResourceLocation exteriorTexture = VersionUtil.lcResource(this.lazyColoredID("block/large_vending_machine/", (Color)((Object)color), "_exterior"));
            String topLeftID = this.lazyColoredID("block/large_vending_machine/", (Color)((Object)color), "_top_left");
            String topRightID = this.lazyColoredID("block/large_vending_machine/", (Color)((Object)color), "_top_right");
            String bottomLeftID = this.lazyColoredID("block/large_vending_machine/", (Color)((Object)color), "_bottom_left");
            String bottomRightID = this.lazyColoredID("block/large_vending_machine/", (Color)((Object)color), "_bottom_right");
            String itemID = this.lazyColoredID("block/large_vending_machine/", (Color)((Object)color), "_item");
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(topLeftID)).parent(this.lazyBlockModel("large_vending_machine/base_top_left", true))).texture("exterior", exteriorTexture)).texture("interior", interiorTexture);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(topRightID)).parent(this.lazyBlockModel("large_vending_machine/base_top_right", true))).texture("exterior", exteriorTexture)).texture("interior", interiorTexture);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(bottomLeftID)).parent(this.lazyBlockModel("large_vending_machine/base_bottom_left", true))).texture("exterior", exteriorTexture)).texture("interior", interiorTexture);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(bottomRightID)).parent(this.lazyBlockModel("large_vending_machine/base_bottom_right", true))).texture("exterior", exteriorTexture)).texture("interior", interiorTexture);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(itemID)).parent(this.lazyBlockModel("large_vending_machine/base_item", true))).texture("exterior", exteriorTexture)).texture("interior", interiorTexture);
            this.registerTallWideRotatable((RegistryObject<? extends Block>)block, topLeftID, topRightID, bottomLeftID, bottomRightID, itemID, false);
        });
        ModBlocks.SHELF.forEach((type, block) -> {
            String modelID = this.lazyWoodenID("block/shelf/", (WoodType)type);
            WoodData data = type.getData();
            if (data != null) {
                ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelID)).parent(this.lazyBlockModel("shelf/base", true))).texture("main", data.plankTexture);
            } else {
                LightmansCurrency.LogWarning("Could not generate models for wood type '" + type.id + "' as it has no wood data!");
            }
            this.registerRotatable((RegistryObject<? extends Block>)block, modelID, false);
        });
        ModBlocks.SHELF_2x2.forEach((type, block) -> {
            String modelID = this.lazyWoodenID("block/shelf2/", (WoodType)type);
            WoodData data = type.getData();
            if (data != null) {
                ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelID)).parent(this.lazyBlockModel("shelf2/base", true))).texture("main", data.plankTexture);
            } else {
                LightmansCurrency.LogWarning("Could not generate models for wood type '" + type.id + "' as it has no wood data!");
            }
            this.registerRotatable((RegistryObject<? extends Block>)block, modelID, false);
        });
        ModBlocks.CARD_DISPLAY.forEach((type, color, block) -> {
            String modelID = this.lazyWoodenID("block/card_display/", (WoodType)type, "/" + color.getResourceSafeName());
            WoodData data = type.getData();
            if (data != null) {
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelID)).parent(this.lazyBlockModel("card_display/base", true))).texture("log", data.logSideTexture)).texture("logtop", data.logTopTexture)).texture("plank", data.plankTexture)).texture("wool", ColorHelper.GetWoolTextureOfColor(color));
            }
            this.registerRotatable((RegistryObject<? extends Block>)block, modelID, false);
        });
        ModBlocks.FREEZER.forEach((color, block) -> {
            ResourceLocation concreteTexture = ColorHelper.GetConcreteTextureOfColor(color);
            String topModelID = this.lazyColoredID("block/freezer/", (Color)((Object)color), "_top");
            String bottomModelID = this.lazyColoredID("block/freezer/", (Color)((Object)color), "_bottom");
            String itemModelID = this.lazyColoredID("block/freezer/", (Color)((Object)color), "_item");
            String doorModelID = this.lazyColoredID("block/freezer/doors/", (Color)((Object)color));
            ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(topModelID)).parent(this.lazyBlockModel("freezer/base_top", true))).texture("concrete", concreteTexture);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(bottomModelID)).parent(this.lazyBlockModel("freezer/base_bottom", true))).texture("concrete", concreteTexture);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(itemModelID)).parent(this.lazyBlockModel("freezer/base_item", true))).texture("concrete", concreteTexture);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(doorModelID)).parent(this.lazyBlockModel("freezer/doors/base", true))).texture("concrete", concreteTexture);
            this.registerTallRotatable((RegistryObject<? extends Block>)block, topModelID, bottomModelID, itemModelID, false);
        });
        this.registerTallRotatable(ModBlocks.ARMOR_DISPLAY, "armor_display_top", "armor_display_bottom", "armor_display", true);
        this.registerTallRotatable(ModBlocks.TICKET_KIOSK, "ticket_kiosk_top", "ticket_kiosk_bottom", "ticket_kiosk", true);
        ModBlocks.BOOKSHELF_TRADER.forEach((type, block) -> {
            String modelID = this.lazyWoodenID("block/bookshelf_trader/", (WoodType)type);
            WoodData data = type.getData();
            if (data != null) {
                ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelID)).parent(this.lazyBlockModel("bookshelf_trader/base", true))).texture("main", data.plankTexture);
            }
            this.registerRotatable((RegistryObject<? extends Block>)block, modelID, false);
        });
        this.registerTallRotatableInv(ModBlocks.SLOT_MACHINE, "slot_machine/top", "slot_machine/bottom", "slot_machine/item", true);
        ModBlocks.GACHA_MACHINE.forEach((color, block) -> {
            String modelID = this.lazyColoredID("block/gacha_machine/", (Color)((Object)color));
            ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelID)).parent(this.lazyBlockModel("gacha_machine/base", true))).texture("main", VersionUtil.lcResource("block/gacha_machine/" + color.getResourceSafeName()));
            this.registerRotatable((RegistryObject<? extends Block>)block, modelID, false);
        });
        this.registerPaygate(ModBlocks.PAYGATE, "paygate_powered", "paygate_unpowered");
        this.registerRotatable(ModBlocks.ITEM_NETWORK_TRADER_1, "item_network_trader_1", true);
        this.registerRotatable(ModBlocks.ITEM_NETWORK_TRADER_2, "item_network_trader_2", true);
        this.registerRotatable(ModBlocks.ITEM_NETWORK_TRADER_3, "item_network_trader_3", true);
        this.registerRotatable(ModBlocks.ITEM_NETWORK_TRADER_4, "item_network_trader_4", true);
        this.registerRotatable(ModBlocks.COMMAND_TRADER);
        this.registerRotatable(ModBlocks.ITEM_TRADER_INTERFACE);
        this.registerRotatable(ModBlocks.TERMINAL);
        this.registerRotatable(ModBlocks.GEM_TERMINAL);
        this.registerBasicItem(ModItems.PORTABLE_GEM_TERMINAL);
        this.registerRotatable(ModBlocks.TICKET_STATION);
        this.registerBasicItem(ModItems.TICKET);
        this.registerLayeredItem(ModItems.TICKET_MASTER);
        this.registerLayeredItem(ModItems.TICKET_PASS);
        this.registerBasicItem(ModItems.TICKET_STUB);
        this.registerBasicItem(ModItems.GOLDEN_TICKET);
        this.registerLayeredItem(ModItems.GOLDEN_TICKET_MASTER);
        this.registerLayeredItem(ModItems.GOLDEN_TICKET_PASS);
        this.registerBasicItem(ModItems.GOLDEN_TICKET_STUB);
        ModBlocks.AUCTION_STAND.forEach((type, block) -> {
            String modelID = this.lazyWoodenID("block/auction_stand/", (WoodType)type);
            WoodData data = type.getData();
            if (data != null) {
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelID)).parent(this.lazyBlockModel("auction_stand/base", true))).texture("log", data.logSideTexture)).texture("log_top", data.logTopTexture);
            } else {
                LightmansCurrency.LogError("Missing Wood Data for " + type.id + "!");
            }
            this.registerSimpleState((RegistryObject<? extends Block>)block, modelID, false);
        });
        this.getVariantBuilder((Block)ModBlocks.COIN_CHEST.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.ExistingModelFile(VersionUtil.vanillaResource("block/chest"), this.models().existingFileHelper)).build());
        this.registerBlockItemModel(ModBlocks.COIN_CHEST, (ModelFile)new ModelFile.ExistingModelFile(VersionUtil.vanillaResource("item/chest"), this.models().existingFileHelper));
        ((ItemModelBuilder)this.itemModels().getBuilder("item/gacha_ball")).parent((ModelFile)new ModelFile.ExistingModelFile(VersionUtil.vanillaResource("item/chest"), this.models().existingFileHelper));
        this.registerRotatable(ModBlocks.PIGGY_BANK, "jars/piggy_bank", true);
        this.registerRotatable(ModBlocks.COINJAR_BLUE, "jars/coinjar_blue", true);
        this.registerMoneyBag(ModBlocks.MONEY_BAG, "money_bag");
        this.registerUpgradeItem(ModItems.ITEM_CAPACITY_UPGRADE_1, UPGRADE_ITEM_CAPACITY, UPGRADE_TIER_IRON);
        this.registerUpgradeItem(ModItems.ITEM_CAPACITY_UPGRADE_2, UPGRADE_ITEM_CAPACITY, UPGRADE_TIER_GOLD);
        this.registerUpgradeItem(ModItems.ITEM_CAPACITY_UPGRADE_3, UPGRADE_ITEM_CAPACITY, UPGRADE_TIER_DIAMOND);
        this.registerUpgradeItem(ModItems.ITEM_CAPACITY_UPGRADE_4, UPGRADE_ITEM_CAPACITY, UPGRADE_TIER_NETHERITE);
        this.registerUpgradeItem(ModItems.SPEED_UPGRADE_1, UPGRADE_SPEED, UPGRADE_TIER_IRON);
        this.registerUpgradeItem(ModItems.SPEED_UPGRADE_2, UPGRADE_SPEED, UPGRADE_TIER_GOLD);
        this.registerUpgradeItem(ModItems.SPEED_UPGRADE_3, UPGRADE_SPEED, UPGRADE_TIER_EMERALD);
        this.registerUpgradeItem(ModItems.SPEED_UPGRADE_4, UPGRADE_SPEED, UPGRADE_TIER_DIAMOND);
        this.registerUpgradeItem(ModItems.SPEED_UPGRADE_5, UPGRADE_SPEED, UPGRADE_TIER_NETHERITE);
        this.registerUpgradeItem(ModItems.OFFER_UPGRADE_1, UPGRADE_TRADE_OFFER, UPGRADE_TIER_COPPER);
        this.registerUpgradeItem(ModItems.OFFER_UPGRADE_2, UPGRADE_TRADE_OFFER, UPGRADE_TIER_IRON);
        this.registerUpgradeItem(ModItems.OFFER_UPGRADE_3, UPGRADE_TRADE_OFFER, UPGRADE_TIER_GOLD);
        this.registerUpgradeItem(ModItems.OFFER_UPGRADE_4, UPGRADE_TRADE_OFFER, UPGRADE_TIER_EMERALD);
        this.registerUpgradeItem(ModItems.OFFER_UPGRADE_5, UPGRADE_TRADE_OFFER, UPGRADE_TIER_DIAMOND);
        this.registerUpgradeItem(ModItems.OFFER_UPGRADE_6, UPGRADE_TRADE_OFFER, UPGRADE_TIER_NETHERITE);
        this.registerUpgradeItem(ModItems.NETWORK_UPGRADE, UPGRADE_NETWORK, UPGRADE_TIER_GOLD);
        this.registerUpgradeItem(ModItems.VOID_UPGRADE, UPGRADE_VOID, UPGRADE_TIER_GOLD);
        this.registerUpgradeItem(ModItems.HOPPER_UPGRADE, UPGRADE_HOPPER, UPGRADE_TIER_GOLD);
        this.registerUpgradeItem(ModItems.COIN_CHEST_EXCHANGE_UPGRADE, UPGRADE_CC_EXCHANGE, UPGRADE_TIER_IRON);
        this.registerUpgradeItem(ModItems.COIN_CHEST_MAGNET_UPGRADE_1, UPGRADE_CC_MAGNET, UPGRADE_TIER_COPPER);
        this.registerUpgradeItem(ModItems.COIN_CHEST_MAGNET_UPGRADE_2, UPGRADE_CC_MAGNET, UPGRADE_TIER_IRON);
        this.registerUpgradeItem(ModItems.COIN_CHEST_MAGNET_UPGRADE_3, UPGRADE_CC_MAGNET, UPGRADE_TIER_GOLD);
        this.registerUpgradeItem(ModItems.COIN_CHEST_MAGNET_UPGRADE_4, UPGRADE_CC_MAGNET, UPGRADE_TIER_EMERALD);
        this.registerUpgradeItem(ModItems.COIN_CHEST_BANK_UPGRADE, UPGRADE_CC_BANK, UPGRADE_TIER_DIAMOND);
        this.registerUpgradeItem(ModItems.COIN_CHEST_SECURITY_UPGRADE, UPGRADE_CC_SECURITY, UPGRADE_TIER_DIAMOND);
        this.registerBasicItem(ModItems.UPGRADE_SMITHING_TEMPLATE);
        this.registerRotatable(ModBlocks.TAX_COLLECTOR);
        this.registerRotatableInv(ModBlocks.SUS_JAR, "jars/sus_jar", true);
        this.registerUpgradeItem(ModItems.INTERACTION_UPGRADE_1, UPGRADE_NETWORK, UPGRADE_TIER_EMERALD);
        this.registerUpgradeItem(ModItems.INTERACTION_UPGRADE_2, UPGRADE_NETWORK, UPGRADE_TIER_DIAMOND);
        this.registerUpgradeItem(ModItems.INTERACTION_UPGRADE_3, UPGRADE_NETWORK, UPGRADE_TIER_NETHERITE);
    }

    private void registerBasicItem(RegistryObject<? extends ItemLike> item) {
        this.itemModels().basicItem(((ItemLike)item.get()).m_5456_());
    }

    private void registerLayeredItem(RegistryObject<? extends ItemLike> item) {
        ResourceLocation itemID = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((ItemLike)item.get()).m_5456_()));
        this.itemModels().basicItem(itemID).texture("layer1", VersionUtil.modResource(itemID.m_135827_(), "item/" + itemID.m_135815_() + "_overlay"));
    }

    private void registerUpgradeItem(@Nonnull RegistryObject<? extends ItemLike> item, @Nonnull ResourceLocation base, @Nonnull ResourceLocation tier) {
        ResourceLocation itemID = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((ItemLike)item.get()).m_5456_()));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(itemID.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", base)).texture("layer1", tier);
    }

    private void registerWalletItem(@Nonnull RegistryObject<? extends WalletItem> item) {
        this.registerBasicItem(item);
        ResourceLocation hipModel = ((WalletItem)((Object)item.get())).model;
        if (hipModel != null) {
            ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)((Item)item.get()));
            ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(hipModel.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(WALLET_MODEL_BASE, this.models().existingFileHelper))).texture("main", itemID.m_246208_("item/wallet_hip/"));
        }
    }

    private void registerBlockItemModel(RegistryObject<? extends Block> block, String itemModel, boolean check) {
        this.registerBlockItemModel(block, this.lazyBlockModel(itemModel, check));
    }

    private void registerBlockItemModel(RegistryObject<? extends Block> block, ModelFile itemModel) {
        ((ItemModelBuilder)this.itemModels().getBuilder(ForgeRegistries.ITEMS.getKey((Object)((Block)block.get()).m_5456_()).toString())).parent(itemModel);
    }

    private void registerSimpleState(RegistryObject<? extends Block> block) {
        this.registerSimpleState(block, this.lazyBlockID(block));
    }

    private void registerSimpleState(RegistryObject<? extends Block> block, String modelID) {
        this.registerSimpleState(block, modelID, true);
    }

    private void registerSimpleState(RegistryObject<? extends Block> block, String modelID, boolean check) {
        ModelFile model = this.lazyBlockModel(modelID, check);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
        this.registerBlockItemModel(block, model);
    }

    private void registerCoinPile(RegistryObject<? extends Block> block) {
        String modelID = this.lazyBlockID(block);
        ResourceLocation texture = ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_246208_("block/");
        ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelID)).parent(this.lazyBlockModel("coin_pile", true))).texture("main", texture);
        ModelFile model = this.lazyBlockModel(modelID, false);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).rotationY(this.getRotationY((BlockState)state)).build());
        this.registerBasicItem(block);
    }

    private void registerCoinBlock(RegistryObject<? extends Block> block) {
        String modelID = this.lazyBlockID(block);
        ResourceLocation texture = ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_246208_("block/");
        ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelID)).parent(this.lazyBlockModel("coin_block", true))).texture("main", texture);
        this.registerSimpleState(block, modelID);
    }

    private void registerAncientCoin(RegistryObject<? extends Item> item) {
        ResourceLocation itemModel = this.lazyItemModelID(this.lazyItemID(item));
        ItemModelBuilder builder = (ItemModelBuilder)this.itemModels().getBuilder(itemModel.toString());
        for (AncientCoinType type : AncientCoinType.values()) {
            ResourceLocation location = type.texture();
            ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(location.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", location);
            builder.override().predicate(AncientCoinItem.PROPERTY, (float)type.ordinal() + 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(location));
        }
    }

    private void registerPaygate(RegistryObject<? extends Block> block, String poweredModelID, String unpoweredModelID) {
        ModelFile powered = this.lazyBlockModel(poweredModelID, true);
        ModelFile unpowered = this.lazyBlockModel(unpoweredModelID, true);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((Integer)state.m_61143_((Property)PaygateBlock.POWER_LEVEL) > 0 ? powered : unpowered).rotationY(this.getRotationY((BlockState)state)).build());
        this.registerBlockItemModel(block, powered);
    }

    private void registerMoneyBag(RegistryObject<? extends Block> block, String folder) {
        ArrayList<ModelFile> models = new ArrayList<ModelFile>();
        for (int i = 0; i <= 3; ++i) {
            models.add(this.lazyBlockModel(folder + "/" + i, true));
        }
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)models.get((Integer)state.m_61143_((Property)MoneyBagBlock.SIZE))).rotationY(this.getRotationYInv((BlockState)state)).build());
        ResourceLocation itemModel = this.lazyItemModelID(this.lazyItemID(block));
        ItemModelBuilder builder = (ItemModelBuilder)this.itemModels().getBuilder(itemModel.toString());
        for (int i = 0; i <= 3; ++i) {
            builder.override().predicate(MoneyBagItem.PROPERTY, (float)i).model((ModelFile)models.get(i));
        }
    }

    private void registerRotatable(RegistryObject<? extends Block> block) {
        this.registerRotatable(block, this.lazyBlockID(block), true);
    }

    private void registerRotatable(RegistryObject<? extends Block> block, String modelID, boolean check) {
        ModelFile model = this.lazyBlockModel(modelID, check);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).rotationY(this.getRotationY((BlockState)state)).build());
        this.registerBlockItemModel(block, model);
    }

    private void registerRotatableInv(RegistryObject<? extends Block> block, String modelID, boolean check) {
        ModelFile model = this.lazyBlockModel(modelID, check);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).rotationY(this.getRotationYInv((BlockState)state)).build());
        this.registerBlockItemModel(block, model);
    }

    private void registerTallRotatableInv(RegistryObject<? extends Block> block, String topModelID, String bottomModelID, String itemModelID, boolean check) {
        ModelFile top = this.lazyBlockModel(topModelID, check);
        ModelFile bottom = this.lazyBlockModel(bottomModelID, check);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getTopBottomModel((BlockState)state, top, bottom)).rotationY(this.getRotationYInv((BlockState)state)).build());
        this.registerBlockItemModel(block, itemModelID, check);
    }

    private void registerTallRotatable(RegistryObject<? extends Block> block, String topModelID, String bottomModelID, String itemModelID, boolean check) {
        ModelFile top = this.lazyBlockModel(topModelID, check);
        ModelFile bottom = this.lazyBlockModel(bottomModelID, check);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getTopBottomModel((BlockState)state, top, bottom)).rotationY(this.getRotationY((BlockState)state)).build());
        this.registerBlockItemModel(block, itemModelID, check);
    }

    private void registerTallWideRotatable(RegistryObject<? extends Block> block, String topLeftModelID, String topRightModelID, String bottomLeftModelID, String bottomRightModelID, String itemModelID, boolean check) {
        ModelFile topLeft = this.lazyBlockModel(topLeftModelID, check);
        ModelFile topRight = this.lazyBlockModel(topRightModelID, check);
        ModelFile bottomLeft = this.lazyBlockModel(bottomLeftModelID, check);
        ModelFile bottomRight = this.lazyBlockModel(bottomRightModelID, check);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getTopBottomLeftRightModel((BlockState)state, topLeft, topRight, bottomLeft, bottomRight)).rotationY(this.getRotationY((BlockState)state)).build());
        this.registerBlockItemModel(block, itemModelID, check);
    }

    private String lazyColoredID(String prefix, Color color) {
        return this.lazyColoredID(prefix, color, "");
    }

    private String lazyColoredID(String prefix, Color color, String postFix) {
        return prefix + color.getResourceSafeName() + postFix;
    }

    private String lazyWoodenID(String prefix, WoodType type) {
        return type.generateResourceLocation(prefix);
    }

    private String lazyWoodenID(String prefix, WoodType type, String postFix) {
        return type.generateResourceLocation(prefix, postFix);
    }

    private String lazyItemID(RegistryObject<? extends ItemLike> item) {
        return ForgeRegistries.ITEMS.getKey((Object)((ItemLike)item.get()).m_5456_()).m_135815_();
    }

    private String lazyBlockID(RegistryObject<? extends Block> block) {
        return ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_();
    }

    private ResourceLocation lazyItemModelID(String modelID) {
        return VersionUtil.lcResource((String)(modelID.startsWith("item/") ? modelID : "item/" + modelID));
    }

    private ResourceLocation lazyBlockModelID(String modelID) {
        return VersionUtil.lcResource((String)(modelID.startsWith("block/") ? modelID : "block/" + modelID));
    }

    private ModelFile lazyBlockModel(String modelID, boolean check) {
        return check ? new ModelFile.ExistingModelFile(this.lazyBlockModelID(modelID), this.models().existingFileHelper) : new ModelFile.UncheckedModelFile(this.lazyBlockModelID(modelID));
    }

    private int getRotationYInv(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)IRotatableBlock.FACING)) {
            case Direction.WEST -> 90;
            case Direction.NORTH -> 180;
            case Direction.EAST -> 270;
            default -> 0;
        };
    }

    private int getRotationY(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)IRotatableBlock.FACING)) {
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
    }

    private ModelFile getTopBottomModel(BlockState state, ModelFile top, ModelFile bottom) {
        return (Boolean)state.m_61143_((Property)ITallBlock.ISBOTTOM) != false ? bottom : top;
    }

    private ModelFile getTopBottomLeftRightModel(BlockState state, ModelFile topLeft, ModelFile topRight, ModelFile bottomLeft, ModelFile bottomRight) {
        if (((Boolean)state.m_61143_((Property)ITallBlock.ISBOTTOM)).booleanValue()) {
            return (Boolean)state.m_61143_((Property)IWideBlock.ISLEFT) != false ? bottomLeft : bottomRight;
        }
        return (Boolean)state.m_61143_((Property)IWideBlock.ISLEFT) != false ? topLeft : topRight;
    }
}

