/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.util;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;

public class TooltipHelper {
    public static final int DEFAULT_TOOLTIP_WIDTH = 256;

    public static List<Component> splitTooltips(@Nonnull List<Component> list, ChatFormatting ... formatting) {
        return TooltipHelper.splitTooltips(list, 256, formatting);
    }

    public static List<Component> splitTooltips(@Nonnull List<Component> list, int lineWidth, ChatFormatting ... formatting) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Component c : list) {
            result.addAll(TooltipHelper.splitTooltips(c, lineWidth, formatting));
        }
        return result;
    }

    public static List<Component> splitTooltips(@Nonnull Component component, ChatFormatting ... formatting) {
        return TooltipHelper.splitTooltips(component, 256, formatting);
    }

    public static List<Component> splitTooltips(@Nonnull Component component, int lineWidth, ChatFormatting ... formatting) {
        String s = component.getString();
        ArrayList<String> words = new ArrayList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(Minecraft.m_91087_().getLocale());
        iterator.setText(s);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            words.add(s.substring(start, end));
            start = end;
            end = iterator.next();
        }
        List<String> lines = TooltipHelper.getLines(lineWidth, words);
        ArrayList<Component> formattedLines = new ArrayList<Component>(lines.size());
        for (String string : lines) {
            formattedLines.add((Component)Component.m_237113_((String)string).m_130944_(formatting));
        }
        return formattedLines;
    }

    @Nonnull
    public static String lazyFormat(@Nonnull Component word, ChatFormatting ... format) {
        return TooltipHelper.lazyFormat(word.getString(), format);
    }

    @Nonnull
    public static String lazyFormat(@Nonnull String word, ChatFormatting ... format) {
        StringBuilder builder = new StringBuilder();
        for (ChatFormatting f : format) {
            builder.append('\u00a7').append(f.m_178510_());
        }
        return builder.append(word).append('\u00a7').append(ChatFormatting.RESET.m_178510_()).toString();
    }

    @Nonnull
    private static List<String> getLines(int lineWidth, List<String> words) {
        Font font = Minecraft.m_91087_().f_91062_;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.m_92895_(TooltipHelper.hideFormatting(word));
            if (width + newWidth > lineWidth) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    @Nonnull
    private static String hideFormatting(@Nonnull String word) {
        int index = ((String)word).indexOf(167);
        while (index >= 0) {
            word = index == 0 ? ((String)word).substring(2) : (index >= ((String)word).length() - 2 ? ((String)word).substring(0, index) : ((String)word).substring(0, index) + ((String)word).substring(index + 2));
            index = ((String)word).indexOf(167);
        }
        return word;
    }
}

