/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.TimedSaleTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.PriceTweakingTradeRule;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TimedSale
extends PriceTweakingTradeRule {
    public static final TradeRuleType<TimedSale> TYPE = new TradeRuleType(VersionUtil.lcResource("timed_sale"), TimedSale::new);
    long startTime = 0L;
    long duration = 0L;
    int discount = 10;

    public void setStartTime(long time) {
        this.startTime = time;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean timerActive() {
        return this.startTime != 0L && TimeUtil.compareTime(this.duration, this.startTime);
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = MathUtil.clamp(duration, 1000L, Long.MAX_VALUE);
    }

    public int getDiscount() {
        return this.discount;
    }

    public void setDiscount(int discount) {
        this.discount = MathUtil.clamp(discount, 1, 100);
    }

    private TimedSale() {
        super(TYPE);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_TIMED_SALE;
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.timerActive()) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.addHelpful(LCText.TRADE_RULE_TIMED_SALE_INFO_SALE.get(this.discount, this.getTimeRemaining().getString()));
                    break;
                }
                case PURCHASE: {
                    event.addHelpful(LCText.TRADE_RULE_TIMED_SALE_INFO_PURCHASE.get(this.discount, this.getTimeRemaining().getString()));
                    break;
                }
            }
        }
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.timerActive() && TimeUtil.compareTime(this.duration, this.startTime)) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.giveDiscount(this.discount);
                    break;
                }
                case PURCHASE: {
                    event.hikePrice(this.discount);
                    break;
                }
            }
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        if (this.confirmStillActive()) {
            event.markDirty();
        }
    }

    private boolean confirmStillActive() {
        if (!this.timerActive()) {
            return false;
        }
        if (!TimeUtil.compareTime(this.duration, this.startTime)) {
            this.startTime = 0L;
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128356_("startTime", this.startTime);
        compound.m_128356_("duration", this.duration);
        compound.m_128405_("discount", this.discount);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("duration", (Number)this.duration);
        json.addProperty("discount", (Number)this.discount);
        return json;
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128425_("startTime", 4)) {
            this.startTime = compound.m_128454_("startTime");
        }
        if (compound.m_128425_("duration", 4)) {
            this.duration = compound.m_128454_("duration");
        }
        if (compound.m_128425_("discount", 3)) {
            this.discount = compound.m_128451_("discount");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("duration")) {
            this.duration = json.get("duration").getAsLong();
        }
        if (json.has("discount")) {
            this.discount = MathUtil.clamp(this.discount, 0, 100);
        }
    }

    @Override
    public void handleUpdateMessage(Player player, LazyPacketData updateInfo) {
        if (updateInfo.contains("Discount")) {
            this.discount = updateInfo.getInt("Discount");
        } else if (updateInfo.contains("Duration")) {
            this.duration = updateInfo.getLong("Duration");
        } else if (updateInfo.contains("StartSale")) {
            if (this.startTime != 0L) {
                return;
            }
            this.startTime = TimeUtil.getCurrentTime();
        } else if (updateInfo.contains("StopSale")) {
            if (this.startTime == 0L) {
                return;
            }
            this.startTime = 0L;
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        CompoundTag compound = new CompoundTag();
        compound.m_128356_("startTime", this.startTime);
        return compound;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        if (data.m_128425_("startTime", 4)) {
            this.startTime = data.m_128454_("startTime");
        }
    }

    public TimeUtil.TimeData getTimeRemaining() {
        if (!this.timerActive()) {
            return new TimeUtil.TimeData(0L);
        }
        return new TimeUtil.TimeData(this.startTime + this.duration - TimeUtil.getCurrentTime());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new TimedSaleTab(parent);
    }
}

