/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.FreeSampleTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.PriceTweakingTradeRule;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FreeSample
extends PriceTweakingTradeRule {
    public static final TradeRuleType<FreeSample> TYPE = new TradeRuleType(VersionUtil.lcResource("free_sample"), FreeSample::new);
    private int limit = 1;
    private long timeLimit = 0L;
    Map<UUID, List<Long>> memory = new HashMap<UUID, List<Long>>();
    private int totalCount = 0;

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = MathUtil.clamp(newLimit, 1, 100);
    }

    private boolean enforceTimeLimit() {
        return this.timeLimit > 0L;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimit = timeLimit;
    }

    public void resetMemory() {
        this.memory.clear();
    }

    public int getSampleCount() {
        return this.totalCount;
    }

    private FreeSample() {
        super(TYPE);
    }

    @Override
    protected boolean canActivate(@Nullable ITradeRuleHost host) {
        TradeData trade;
        if (host instanceof TradeData && (trade = (TradeData)host).getTradeDirection() != TradeDirection.SALE) {
            return false;
        }
        return super.canActivate(host);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_FREE_SAMPLE;
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.giveDiscount(event)) {
            if (this.limit > 1) {
                event.addHelpful(LCText.TRADE_RULE_FREE_SAMPLE_INFO_MULTI.get(this.limit));
                int count = this.getFreeSampleCount(event);
                if (count > 0) {
                    event.addHelpful(LCText.TRADE_RULE_FREE_SAMPLE_INFO_USED.get(count, this.limit));
                }
            } else {
                event.addHelpful(LCText.TRADE_RULE_FREE_SAMPLE_INFO_SINGLE.get(new Object[0]));
            }
        } else {
            int count = this.getFreeSampleCount(event);
            if (count > 0) {
                event.addNeutral(LCText.TRADE_RULE_FREE_SAMPLE_INFO_USED.get(count, this.limit));
            }
        }
        if (this.enforceTimeLimit()) {
            event.addNeutral(LCText.TRADE_RULE_FREE_SAMPLE_INFO_TIMED.get(new TimeUtil.TimeData(this.getTimeLimit()).getString()));
        }
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.giveDiscount(event)) {
            event.makeFree();
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        if (this.giveDiscount(event)) {
            this.addToMemory(event.getPlayerReference().id, TimeUtil.getCurrentTime());
            this.clearExpiredData();
            event.markDirty();
        }
    }

    private boolean giveDiscount(TradeEvent event) {
        return event.hasPlayerReference() && this.giveDiscount(event.getPlayerReference().id) && event.getTrade().getTradeDirection() == TradeDirection.SALE;
    }

    private void addToMemory(UUID playerID, Long time) {
        List entry = this.memory.getOrDefault(playerID, new ArrayList());
        entry.add(time);
        this.memory.put(playerID, entry);
        ++this.totalCount;
    }

    private void clearExpiredData() {
        if (!this.enforceTimeLimit()) {
            return;
        }
        ArrayList emptyEntries = new ArrayList();
        this.memory.forEach((id, eventTimes) -> {
            for (int i = 0; i < eventTimes.size(); ++i) {
                if (TimeUtil.compareTime(this.timeLimit, (Long)eventTimes.get(i))) continue;
                eventTimes.remove(i);
                --i;
            }
            if (eventTimes.isEmpty()) {
                emptyEntries.add(id);
            }
        });
        emptyEntries.forEach(id -> this.memory.remove(id));
    }

    public boolean giveDiscount(UUID playerID) {
        return this.getFreeSampleCount(playerID) < this.limit;
    }

    private int getFreeSampleCount(TradeEvent event) {
        return this.getFreeSampleCount(event.getPlayerReference().id);
    }

    private int getFreeSampleCount(UUID playerID) {
        int count = 0;
        if (this.memory.containsKey(playerID)) {
            List<Long> eventTimes = this.memory.get(playerID);
            if (!this.enforceTimeLimit()) {
                return eventTimes.size();
            }
            for (Long eventTime : eventTimes) {
                if (!TimeUtil.compareTime(this.timeLimit, eventTime)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128405_("Limit", this.limit);
        compound.m_128356_("ForgetTime", this.timeLimit);
        this.saveMemory(compound);
    }

    private void saveMemory(CompoundTag compound) {
        compound.m_128405_("Total", this.totalCount);
        ListTag memoryList = new ListTag();
        this.memory.forEach((id, entries) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("ID", id);
            tag.m_128428_("Times", entries);
            memoryList.add((Object)tag);
        });
        compound.m_128365_("Memory", (Tag)memoryList);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Limit", (Number)this.limit);
        if (this.enforceTimeLimit()) {
            json.addProperty("ForgetTime", (Number)this.timeLimit);
        }
        return json;
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128425_("Limit", 3)) {
            this.limit = compound.m_128451_("Limit");
        }
        if (compound.m_128441_("ForgetTime")) {
            this.timeLimit = compound.m_128454_("ForgetTime");
        }
        this.loadMemory(compound);
    }

    private void loadMemory(CompoundTag compound) {
        if (compound.m_128441_("Total")) {
            this.totalCount = compound.m_128451_("Total");
        }
        if (compound.m_128425_("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = compound.m_128437_("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                ArrayList<Long> eventTimes;
                CompoundTag tag = memoryList.m_128728_(i);
                if (tag.m_128441_("ID")) {
                    eventTimes = new ArrayList<Long>();
                    if (tag.m_128441_("Times")) {
                        for (long time : tag.m_128467_("Times")) {
                            eventTimes.add(time);
                        }
                    } else {
                        eventTimes.add(TimeUtil.getCurrentTime());
                        ++this.totalCount;
                    }
                    this.memory.put(tag.m_128342_("ID"), eventTimes);
                    continue;
                }
                if (!tag.m_128441_("id")) continue;
                eventTimes = new ArrayList();
                eventTimes.add(TimeUtil.getCurrentTime());
                this.memory.put(tag.m_128342_("id"), eventTimes);
            }
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        CompoundTag data = new CompoundTag();
        this.saveMemory(data);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        this.loadMemory(data);
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Limit")) {
            this.limit = json.get("Limit").getAsInt();
        }
        if (json.has("ForgetTime")) {
            this.timeLimit = json.get("ForgetTime").getAsLong();
        }
    }

    @Override
    protected void handleUpdateMessage(Player player, LazyPacketData updateInfo) {
        if (updateInfo.contains("Limit")) {
            this.limit = updateInfo.getInt("Limit");
        } else if (updateInfo.contains("TimeLimit")) {
            this.timeLimit = updateInfo.getLong("TimeLimit");
        } else if (updateInfo.contains("ClearMemory")) {
            this.memory.clear();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new FreeSampleTab(parent);
    }
}

