/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.DemandPricingTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.PriceTweakingTradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DemandPricing
extends PriceTweakingTradeRule {
    public static final TradeRuleType<DemandPricing> TYPE = new TradeRuleType(VersionUtil.lcResource("demand_pricing"), DemandPricing::new);
    public static final int UPPER_STOCK_LIMIT = 100000;
    private MoneyValue otherPrice = MoneyValue.empty();
    private int smallStock = 1;
    private int largeStock = 100;

    public MoneyValue getOtherPrice() {
        return this.otherPrice;
    }

    public void setOtherPrice(MoneyValue otherPrice) {
        this.otherPrice = otherPrice;
    }

    public int getSmallStock() {
        return this.smallStock;
    }

    public void setSmallStock(int smallStock) {
        this.smallStock = MathUtil.clamp(smallStock, 1, this.largeStock - 1);
    }

    public int getLargeStock() {
        return this.largeStock;
    }

    public void setLargeStock(int largeStock) {
        this.largeStock = MathUtil.clamp(largeStock, this.smallStock + 1, 100000);
    }

    private DemandPricing() {
        super(TYPE);
    }

    @Override
    protected boolean allowHost(ITradeRuleHost host) {
        return super.allowHost(host) && host.isTrade();
    }

    @Override
    protected boolean canActivate(@Nullable ITradeRuleHost host) {
        TradeData trade;
        if (host instanceof TradeData && (trade = (TradeData)host).getTradeDirection() != TradeDirection.SALE) {
            return false;
        }
        return super.canActivate(host);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_DEMAND_PRICING;
    }

    @Override
    protected boolean onlyAllowOnTrades() {
        return true;
    }

    public MutableComponent getInfo() {
        ITradeRuleHost iTradeRuleHost = this.getHost();
        if (iTradeRuleHost instanceof TradeData) {
            TradeData trade = (TradeData)iTradeRuleHost;
            if (trade.getTradeDirection() != TradeDirection.SALE) {
                return LCText.GUI_DEMAND_PRICING_INFO_INVALID_HOST.get(new Object[0]);
            }
            MoneyValue smallPrice = trade.getCost();
            MoneyValue largePrice = this.otherPrice;
            if (largePrice.getCoreValue() < smallPrice.getCoreValue()) {
                MoneyValue temp = largePrice;
                largePrice = smallPrice;
                smallPrice = temp;
            }
            if (!largePrice.sameType(smallPrice) || !smallPrice.isValidPrice() || largePrice.isEmpty() || largePrice.getCoreValue() == smallPrice.getCoreValue()) {
                return LCText.GUI_DEMAND_PRICING_INFO_INVALID_PRICE.get(new Object[0]);
            }
            if (this.largeStock <= this.smallStock) {
                return LCText.GUI_DEMAND_PRICING_INFO_INVALID_STOCK.get(new Object[0]);
            }
            return LCText.GUI_DEMAND_PRICING_INFO.get(largePrice.getText().m_130940_(ChatFormatting.WHITE), smallPrice.getText().m_130940_(ChatFormatting.WHITE), this.largeStock, this.smallStock);
        }
        return LCText.GUI_DEMAND_PRICING_INFO_INVALID_HOST.get(new Object[0]);
    }

    public boolean isValid(TradeData trade, @Nullable TraderData trader) {
        return this.isValid(trade, trade.getCost(), trader);
    }

    public boolean isValid(TradeData trade, MoneyValue tradeCost, @Nullable TraderData trader) {
        if (trader == null) {
            return false;
        }
        MoneyValue smallPrice = tradeCost;
        MoneyValue largePrice = this.otherPrice;
        if (largePrice.getCoreValue() < smallPrice.getCoreValue()) {
            MoneyValue temp = largePrice;
            largePrice = smallPrice;
            smallPrice = temp;
        }
        return !trader.isCreative() && trade.getTradeDirection() == TradeDirection.SALE && largePrice.sameType(smallPrice) && smallPrice.isValidPrice() && !largePrice.isEmpty() && this.largeStock > this.smallStock && smallPrice.getCoreValue() != largePrice.getCoreValue();
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.isValid(event.getTrade(), event.getTrader())) {
            event.addNeutral(LCText.TRADE_RULE_DEMAND_PRICING.get(new Object[0]));
        }
    }

    @Override
    protected void tradeBaseCost(TradeRule.InternalPriceEvent event) {
        if (this.isValid(event.trade, event.getBaseCost(), event.context.getTrader())) {
            int stock = event.trade.getStock(event.context);
            event.setBaseCost(this.calculatePrice(stock, event.getBaseCost()));
        }
    }

    private MoneyValue calculatePrice(int stock, MoneyValue defaultPrice) {
        long minVal;
        MoneyValue smallPrice = defaultPrice;
        MoneyValue largePrice = this.otherPrice;
        if (largePrice.getCoreValue() < smallPrice.getCoreValue()) {
            MoneyValue temp = largePrice;
            largePrice = smallPrice;
            smallPrice = temp;
        }
        if (stock <= this.smallStock) {
            return largePrice;
        }
        if (stock >= this.largeStock) {
            return smallPrice;
        }
        long maxVal = largePrice.getCoreValue();
        long deltaVal = maxVal - (minVal = smallPrice.getCoreValue());
        if (deltaVal <= 0L) {
            return smallPrice;
        }
        int deltaStock = this.largeStock - this.smallStock;
        if (deltaStock <= 0) {
            return smallPrice;
        }
        long result = maxVal - Math.round((double)deltaVal * ((double)(stock - this.smallStock) / (double)deltaStock));
        if (result >= maxVal) {
            return largePrice;
        }
        if (result <= minVal) {
            return smallPrice;
        }
        return largePrice.fromCoreValue(result);
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("OtherPrice", (Tag)this.otherPrice.save());
        compound.m_128405_("SmallStock", this.smallStock);
        compound.m_128405_("LargeStock", this.largeStock);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.otherPrice = MoneyValue.load(compound.m_128469_("OtherPrice"));
        this.smallStock = compound.m_128451_("SmallStock");
        this.largeStock = compound.m_128451_("LargeStock");
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        return null;
    }

    @Override
    public void loadFromJson(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        throw new JsonSyntaxException("DemandPricing is not supported for Persistent Traders");
    }

    @Override
    public CompoundTag savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
    }

    @Override
    protected void handleUpdateMessage(Player player, LazyPacketData updateInfo) {
        if (updateInfo.contains("ChangePrice")) {
            this.otherPrice = updateInfo.getMoneyValue("ChangePrice");
        }
        if (updateInfo.contains("ChangeSmallStock")) {
            this.smallStock = updateInfo.getInt("ChangeSmallStock");
        }
        if (updateInfo.contains("ChangeLargeStock")) {
            this.largeStock = updateInfo.getInt("ChangeLargeStock");
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new DemandPricingTab(parent);
    }
}

