/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettings;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsObject;
import io.github.lightman314.lightmanscurrency.api.ticket.TicketData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.text.TimeUnitTextEntry;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.client.PaygateTradeButtonRenderer;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DemandPricing;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class PaygateTradeData
extends TradeData
implements IDirectionalSettingsObject {
    int duration = 1;
    int level = 15;
    private String description = "";
    private String tooltip = "";
    DirectionalSettings outputSettings = new DirectionalSettings(this);
    Item ticketItem = Items.f_41852_;
    long ticketID = Long.MIN_VALUE;
    int ticketColor = 0xFFFFFF;
    boolean storeTicketStubs = false;

    public PaygateTradeData() {
        super(true);
        for (Direction side : Direction.values()) {
            this.outputSettings.setState(side, DirectionalSettingsState.OUTPUT);
        }
    }

    public int getDuration() {
        return Math.max(this.duration, 1);
    }

    public void setDuration(int duration) {
        this.duration = Math.max(duration, 1);
    }

    public int getRedstoneLevel() {
        return this.level;
    }

    public void setRedstoneLevel(int level) {
        this.level = MathUtil.clamp(level, 1, 15);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public List<Component> getDescriptionTooltip() {
        if (!this.tooltip.isBlank()) {
            ArrayList<Component> lines = new ArrayList<Component>();
            for (String line : this.tooltip.split("\\\\n")) {
                lines.add((Component)EasyText.literal(line));
            }
            return lines;
        }
        return ImmutableList.of((Object)EasyText.literal(this.description));
    }

    public DirectionalSettings getOutputSides() {
        return this.outputSettings;
    }

    @Override
    public boolean allowInputs() {
        return false;
    }

    @Override
    @Nullable
    public Block getDisplayBlock() {
        return (Block)ModBlocks.PAYGATE.get();
    }

    @Override
    @Nonnull
    public DirectionalSettingsState getSidedState(@Nonnull Direction side) {
        return this.outputSettings.getState(side);
    }

    public int getTicketColor() {
        return this.ticketColor;
    }

    public boolean isTicketTrade() {
        return this.ticketID >= -1L;
    }

    public Item getTicketItem() {
        return this.ticketItem;
    }

    public long getTicketID() {
        return this.ticketID;
    }

    public void setTicket(ItemStack ticket) {
        TicketData data = TicketData.getForMaster(ticket);
        if (data != null && TicketItem.isMasterTicket(ticket)) {
            this.ticketItem = data.ticket;
            this.ticketID = TicketItem.GetTicketID(ticket);
            this.ticketColor = TicketItem.GetTicketColor(ticket);
        } else {
            this.ticketItem = Items.f_41852_;
            this.ticketID = Long.MIN_VALUE;
            this.ticketColor = 0xFFFFFF;
        }
        this.validateRuleStates();
    }

    @Override
    public int getStock(@Nonnull TradeContext context) {
        return this.isValid() ? 1 : 0;
    }

    @Override
    public boolean allowTradeRule(@Nonnull TradeRule rule) {
        if (rule instanceof DemandPricing) {
            return false;
        }
        return super.allowTradeRule(rule);
    }

    public boolean shouldStoreTicketStubs() {
        return this.storeTicketStubs;
    }

    public void setStoreTicketStubs(boolean value) {
        this.storeTicketStubs = value;
    }

    public ItemStack getTicketStub() {
        TicketData data = TicketData.getForTicket(new ItemStack((ItemLike)this.ticketItem));
        if (data != null) {
            return new ItemStack((ItemLike)data.ticketStub);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public TradeDirection getTradeDirection() {
        return TradeDirection.SALE;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isTicketTrade()) {
            return context.hasTicket(this.ticketID) || context.hasPass(this.ticketID);
        }
        return context.hasFunds(this.cost);
    }

    @Override
    public boolean isValid() {
        return this.getDuration() >= 1 && (this.isTicketTrade() || super.isValid());
    }

    public static void saveAllData(CompoundTag nbt, List<PaygateTradeData> data) {
        PaygateTradeData.saveAllData(nbt, data, "Trades");
    }

    public static void saveAllData(CompoundTag nbt, List<PaygateTradeData> data, String key) {
        ListTag listNBT = new ListTag();
        for (PaygateTradeData datum : data) {
            listNBT.add((Object)datum.getAsNBT());
        }
        if (!listNBT.isEmpty()) {
            nbt.m_128365_(key, (Tag)listNBT);
        }
    }

    public static PaygateTradeData loadData(CompoundTag nbt) {
        PaygateTradeData trade = new PaygateTradeData();
        trade.loadFromNBT(nbt);
        return trade;
    }

    public static List<PaygateTradeData> loadAllData(CompoundTag nbt) {
        return PaygateTradeData.loadAllData("Trades", nbt);
    }

    public static List<PaygateTradeData> loadAllData(String key, CompoundTag nbt) {
        ListTag listNBT = nbt.m_128437_(key, 10);
        List<PaygateTradeData> data = PaygateTradeData.listOfSize(listNBT.size());
        for (int i = 0; i < listNBT.size(); ++i) {
            data.get(i).loadFromNBT(listNBT.m_128728_(i));
        }
        return data;
    }

    public static List<PaygateTradeData> listOfSize(int tradeCount) {
        ArrayList data = Lists.newArrayList();
        while (data.size() < tradeCount) {
            data.add(new PaygateTradeData());
        }
        return data;
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag compound = super.getAsNBT();
        compound.m_128405_("Duration", this.getDuration());
        compound.m_128405_("Level", this.level);
        compound.m_128359_("Description", this.description);
        compound.m_128359_("Tooltip", this.tooltip);
        this.outputSettings.save(compound, "OutputSides");
        if (this.ticketID >= -1L) {
            compound.m_128359_("TicketItem", ForgeRegistries.ITEMS.getKey((Object)this.ticketItem).toString());
            compound.m_128356_("TicketID", this.ticketID);
            compound.m_128405_("TicketColor", this.ticketColor);
            compound.m_128379_("StoreTicketStubs", this.storeTicketStubs);
        }
        return compound;
    }

    @Override
    protected void loadFromNBT(CompoundTag compound) {
        super.loadFromNBT(compound);
        this.duration = compound.m_128451_("Duration");
        this.outputSettings.load(compound, "OutputSides");
        if (compound.m_128441_("Level")) {
            this.level = compound.m_128451_("Level");
        }
        if (compound.m_128441_("Description")) {
            this.description = compound.m_128461_("Description");
        }
        if (compound.m_128441_("Tooltip")) {
            this.tooltip = compound.m_128461_("Tooltip");
        }
        if (compound.m_128441_("TicketID")) {
            this.ticketID = compound.m_128454_("TicketID");
            this.ticketItem = compound.m_128441_("TicketItem") ? (Item)ForgeRegistries.ITEMS.getValue(VersionUtil.parseResource(compound.m_128461_("TicketItem"))) : (Item)ModItems.TICKET.get();
        } else {
            this.ticketID = Long.MIN_VALUE;
            this.ticketItem = Items.f_41852_;
        }
        if (compound.m_128441_("TicketColor")) {
            this.ticketColor = compound.m_128451_("TicketColor");
        } else if (this.ticketID >= -1L) {
            this.ticketColor = TicketItem.GetDefaultTicketColor(this.ticketID);
        }
        this.storeTicketStubs = compound.m_128441_("StoreTicketStubs") ? compound.m_128471_("StoreTicketStubs") : false;
    }

    @Override
    public TradeComparisonResult compare(TradeData otherTrade) {
        LightmansCurrency.LogWarning("Attempting to compare paygate trades, but paygate trades do not support this interaction.");
        return new TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeComparisonResult result) {
        LightmansCurrency.LogWarning("Attempting to determine if the paygate trades differences are acceptable, but paygate trades do not support this interaction.");
        return false;
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        LightmansCurrency.LogWarning("Attempting to get warnings for different paygate trades, but paygate trades do not support this interaction.");
        return Lists.newArrayList();
    }

    public static MutableComponent formatDurationShort(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        MutableComponent result = EasyText.empty();
        if (hours > 0) {
            result.m_7220_((Component)PaygateTradeData.formatUnitShort(hours, LCText.TIME_UNIT_HOUR));
        }
        if (minutes > 0) {
            result.m_7220_((Component)PaygateTradeData.formatUnitShort(minutes, LCText.TIME_UNIT_MINUTE));
        }
        if (seconds > 0) {
            result.m_7220_((Component)PaygateTradeData.formatUnitShort(seconds, LCText.TIME_UNIT_SECOND));
        }
        if (ticks > 0 || result.getString().isBlank()) {
            result.m_7220_((Component)PaygateTradeData.formatUnitShort(ticks, LCText.TIME_UNIT_TICK));
        }
        return result;
    }

    public static MutableComponent formatDurationDisplay(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        if (hours > 0) {
            return PaygateTradeData.formatUnitShort(hours, LCText.TIME_UNIT_HOUR);
        }
        if (minutes > 0) {
            return PaygateTradeData.formatUnitShort(minutes, LCText.TIME_UNIT_MINUTE);
        }
        if (seconds > 0) {
            return PaygateTradeData.formatUnitShort(seconds, LCText.TIME_UNIT_SECOND);
        }
        return PaygateTradeData.formatUnitShort(ticks, LCText.TIME_UNIT_TICK);
    }

    public static MutableComponent formatDuration(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        MutableComponent result = EasyText.empty();
        boolean addSpacer = false;
        if (hours > 0) {
            PaygateTradeData.appendUnit(result, false, hours, LCText.TIME_UNIT_HOUR);
            addSpacer = true;
        }
        if (minutes > 0) {
            PaygateTradeData.appendUnit(result, addSpacer, minutes, LCText.TIME_UNIT_MINUTE);
            addSpacer = true;
        }
        if (seconds > 0) {
            PaygateTradeData.appendUnit(result, addSpacer, seconds, LCText.TIME_UNIT_SECOND);
            addSpacer = true;
        }
        if (ticks > 0) {
            PaygateTradeData.appendUnit(result, addSpacer, seconds, LCText.TIME_UNIT_TICK);
        }
        return result;
    }

    private static void appendUnit(@Nonnull MutableComponent result, boolean addSpacer, int count, @Nonnull TimeUnitTextEntry entry) {
        if (addSpacer) {
            result.m_7220_((Component)EasyText.literal(" "));
        }
        result.m_7220_((Component)EasyText.literal(String.valueOf(count)));
        if (count > 1) {
            result.m_7220_((Component)entry.pluralText.get(new Object[0]));
        } else {
            result.m_7220_((Component)entry.fullText.get(new Object[0]));
        }
    }

    @Nonnull
    private static MutableComponent formatUnitShort(int count, @Nonnull TimeUnitTextEntry entry) {
        return EasyText.literal(String.valueOf(count)).m_7220_((Component)entry.shortText.get(new Object[0]));
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new PaygateTradeButtonRenderer(this);
    }

    @Override
    public void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            int tradeIndex = paygate.getTradeData().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            if (TicketItem.isMasterTicket(heldItem)) {
                this.setTicket(heldItem);
                if (((ITraderStorageMenu)tab.menu).isClient()) {
                    tab.SendInputInteractionMessage(tradeIndex, 0, data, heldItem);
                }
            } else {
                tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setBoolean("PriceEdit", true));
            }
        }
    }

    @Override
    public void OnOutputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            int tradeIndex = paygate.getTradeData().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setBoolean("PriceEdit", false));
        }
    }

    @Override
    public void OnInteraction(@Nonnull BasicTradeEditTab tab, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            int tradeIndex = paygate.getTradeData().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex));
        }
    }

    @Override
    public boolean isMoneyRelevant() {
        return !this.isTicketTrade();
    }
}

