/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.gacha;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GachaStorage {
    private final Supplier<Integer> maxStorage;
    private final List<ItemStack> contents = new ArrayList<ItemStack>();

    public GachaStorage(Supplier<Integer> maxStorage) {
        this.maxStorage = maxStorage;
    }

    public List<ItemStack> getContents() {
        return this.contents;
    }

    public List<ItemStack> getSplitContents() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : InventoryUtil.copyList(this.contents)) {
            while (stack.m_41613_() > stack.m_41741_()) {
                result.add(stack.m_41620_(stack.m_41741_()));
            }
            if (stack.m_41619_()) continue;
            result.add(stack);
        }
        return result;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.contents.size()) {
            return ItemStack.f_41583_;
        }
        return this.contents.get(slot);
    }

    public ListTag save() {
        ListTag list = new ListTag();
        for (ItemStack item : this.contents) {
            if (item.m_41619_()) continue;
            list.add((Object)InventoryUtil.saveItemNoLimits(item));
        }
        return list;
    }

    public void load(ListTag list) {
        this.contents.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.contents.add(InventoryUtil.loadItemNoLimits(list.m_128728_(i)));
        }
    }

    public JsonArray write() {
        JsonArray list = new JsonArray();
        for (ItemStack item : this.contents) {
            list.add((JsonElement)FileUtil.convertItemStack(item));
        }
        return list;
    }

    public void read(JsonArray list) throws JsonSyntaxException {
        this.contents.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.forceInsertItem(FileUtil.parseItemStack(GsonHelper.m_13918_((JsonElement)list.get(i), (String)("Storage[" + i + "]"))));
        }
    }

    public boolean isEmpty() {
        return this.contents.isEmpty() || this.getItemCount() <= 0;
    }

    public int getItemCount() {
        int count = 0;
        for (ItemStack item : this.contents) {
            count += item.m_41613_();
        }
        return count;
    }

    public int getSpace() {
        return this.maxStorage.get() - this.getItemCount();
    }

    public boolean insertItem(ItemStack item) {
        int space = this.getSpace();
        if (space <= 0) {
            return false;
        }
        for (ItemStack entry : this.contents) {
            if (!InventoryUtil.ItemMatches(entry, item)) continue;
            int fittableAmount = Math.min(space, item.m_41613_());
            entry.m_41769_(fittableAmount);
            item.m_41774_(fittableAmount);
            return true;
        }
        this.contents.add(item.m_41620_(space));
        return true;
    }

    public void forceInsertItem(ItemStack item) {
        for (ItemStack entry : this.contents) {
            if (!InventoryUtil.ItemMatches(entry, item)) continue;
            entry.m_41769_(item.m_41613_());
            return;
        }
        this.contents.add(item.m_41777_());
    }

    public ItemStack removeItem(int slot, int count) {
        if (slot < 0 || slot >= this.contents.size()) {
            return ItemStack.f_41583_;
        }
        ItemStack item = this.contents.get(slot);
        ItemStack result = item.m_41620_(count);
        if (item.m_41619_()) {
            this.contents.remove(slot);
        }
        return result;
    }

    public ItemStack findRandomItem(boolean remove) {
        RandomSource random = RandomSource.m_216327_();
        if (this.contents.isEmpty()) {
            return ItemStack.f_41583_;
        }
        int rand = random.m_188503_(this.getItemCount());
        for (int i = 0; i < this.contents.size(); ++i) {
            ItemStack item = this.contents.get(i);
            if ((rand -= item.m_41613_()) >= 0) continue;
            ItemStack result = item.m_255036_(1);
            if (remove) {
                item.m_41774_(1);
                if (item.m_41619_()) {
                    this.contents.remove(i);
                }
            }
            return result;
        }
        LightmansCurrency.LogWarning("Somehow randomly generated nothing");
        return ItemStack.f_41583_;
    }

    public List<ItemStack> peekRandomItems(RandomSource random, int count) {
        if (this.contents.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        List<ItemStack> contentCopy = InventoryUtil.copyList(this.contents);
        int totalCount = this.getItemCount();
        block0: for (int i = 0; i < count; ++i) {
            int rand = random.m_188503_(totalCount);
            for (int x = 0; x < contentCopy.size(); ++x) {
                ItemStack item = contentCopy.get(x);
                if ((rand -= item.m_41613_()) >= 0) continue;
                result.add(item.m_255036_(1));
                item.m_41774_(1);
                if (item.m_41619_()) {
                    contentCopy.remove(x);
                    if (contentCopy.isEmpty()) {
                        return result;
                    }
                }
                --totalCount;
                continue block0;
            }
        }
        return result;
    }
}

