/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.commands.tradedata;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.commands.CommandTrader;
import io.github.lightman314.lightmanscurrency.common.traders.commands.tradedata.client.CommandTradeButtonRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CommandTrade
extends TradeData {
    private String command = "";
    private String description = "";
    private String tooltip = "";

    public String getCommand() {
        return this.command;
    }

    public String formatCommand(Player player) {
        return this.command.replaceAll("%PLAYER%", player.m_36316_().getName()).replaceAll("%PLAYER_NAME%", player.m_7755_().getString());
    }

    public void setCommand(@Nullable String command) {
        this.command = command == null ? "" : command;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getCommandDisplay() {
        if (!this.description.isBlank()) {
            return this.description;
        }
        if (this.command.isBlank() || this.command.startsWith("/")) {
            return this.command;
        }
        return "/" + this.command;
    }

    public List<Component> getCommandTooltip() {
        if (!this.tooltip.isBlank()) {
            ArrayList<Component> lines = new ArrayList<Component>();
            for (String line : this.tooltip.split("\\\\n")) {
                lines.add((Component)EasyText.literal(line));
            }
            return lines;
        }
        if (this.command.isBlank() || this.command.startsWith("/")) {
            return Lists.newArrayList((Object[])new Component[]{EasyText.literal(this.command)});
        }
        return Lists.newArrayList((Object[])new Component[]{EasyText.literal("/" + this.command)});
    }

    public CommandTrade(boolean validateRules) {
        super(validateRules);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && !this.command.isEmpty();
    }

    @Override
    public TradeDirection getTradeDirection() {
        return TradeDirection.SALE;
    }

    @Override
    public int getStock(TradeContext context) {
        return 1;
    }

    public boolean canAfford(TradeContext context) {
        return context.hasFunds(this.getCost(context));
    }

    public static List<CommandTrade> listOfSize(int size, boolean validateRules) {
        ArrayList<CommandTrade> list = new ArrayList<CommandTrade>();
        while (list.size() < size) {
            list.add(new CommandTrade(validateRules));
        }
        return list;
    }

    @Override
    public TradeComparisonResult compare(TradeData expectedTrade) {
        return new TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeComparisonResult result) {
        return false;
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        return new ArrayList<Component>();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new CommandTradeButtonRenderer(this);
    }

    @Override
    public void OnInputDisplayInteraction(BasicTradeEditTab tab, int index, TradeInteractionData data, ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof CommandTrader) {
            CommandTrader trader = (CommandTrader)traderData;
            int tradeIndex = trader.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setBoolean("CommandEdit", false));
        }
    }

    @Override
    public void OnOutputDisplayInteraction(BasicTradeEditTab tab, int index, TradeInteractionData data, ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof CommandTrader) {
            CommandTrader trader = (CommandTrader)traderData;
            int tradeIndex = trader.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setBoolean("CommandEdit", true));
        }
    }

    @Override
    public void OnInteraction(BasicTradeEditTab tab, TradeInteractionData data, ItemStack heldItem) {
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag tag = super.getAsNBT();
        tag.m_128359_("Command", this.command);
        tag.m_128359_("Description", this.description);
        tag.m_128359_("Tooltip", this.tooltip);
        return tag;
    }

    public static CommandTrade loadData(CompoundTag tag, boolean validateRules) {
        CommandTrade trade = new CommandTrade(validateRules);
        trade.loadFromNBT(tag);
        return trade;
    }

    @Override
    protected void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.command = tag.m_128461_("Command");
        if (tag.m_128441_("Description")) {
            this.description = tag.m_128461_("Description");
        }
        if (tag.m_128441_("Tooltip")) {
            this.tooltip = tag.m_128461_("Tooltip");
        }
    }
}

