/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.events.AuctionHouseEvent;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBuyerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseCancelNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNobidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.common.traders.auction.PersistentAuctionData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.client.AuctionTradeButtonRenderer;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;

public class AuctionTradeData
extends TradeData {
    public static final long OVERTIME_DURATION = 300000L;
    private boolean overtimeAllowed = true;
    private boolean cancelled;
    private String persistentID = "";
    MoneyValue lastBidAmount = MoneyValue.empty();
    PlayerReference lastBidPlayer = null;
    MoneyValue minBidDifference = MoneyValue.empty();
    PlayerReference tradeOwner;
    long startTime = 0L;
    long duration = 0L;
    List<ItemStack> auctionItems = new ArrayList<ItemStack>();

    public static long GetMinimumDuration() {
        if ((Integer)LCConfig.SERVER.auctionHouseDurationMin.get() > 0) {
            return 86400000L * (long)((Integer)LCConfig.SERVER.auctionHouseDurationMin.get()).intValue();
        }
        return 3600000L;
    }

    public static long GetDefaultDuration() {
        if ((Integer)LCConfig.SERVER.auctionHouseDurationMin.get() > 0) {
            return 86400000L * (long)((Integer)LCConfig.SERVER.auctionHouseDurationMin.get()).intValue();
        }
        return 86400000L;
    }

    public boolean hasBid() {
        return this.lastBidPlayer != null;
    }

    public boolean isOvertimeAllowed() {
        return this.overtimeAllowed;
    }

    public void setOvertimeAllowed(boolean value) {
        if (this.isActive()) {
            return;
        }
        this.overtimeAllowed = value;
    }

    public boolean isPersistentID(String id) {
        return this.persistentID.equals(id);
    }

    public MoneyValue getLastBidAmount() {
        return this.lastBidAmount;
    }

    public PlayerReference getLastBidPlayer() {
        return this.lastBidPlayer;
    }

    public void setStartingBid(@Nonnull MoneyValue amount) {
        if (this.isActive()) {
            return;
        }
        this.lastBidAmount = amount;
        if (this.minBidDifference.isEmpty()) {
            this.minBidDifference = this.lastBidAmount.getSmallestValue();
        } else if (!this.minBidDifference.sameType(this.lastBidAmount)) {
            this.minBidDifference = this.lastBidAmount.getSmallestValue();
        }
    }

    public MoneyValue getMinBidDifference() {
        if (this.minBidDifference == null || !this.lastBidAmount.sameType(this.minBidDifference)) {
            this.minBidDifference = this.lastBidAmount.getSmallestValue();
            return this.minBidDifference;
        }
        return this.minBidDifference;
    }

    public void setMinBidDifferent(@Nonnull MoneyValue amount) {
        if (this.isActive()) {
            return;
        }
        if (!this.lastBidAmount.sameType(amount)) {
            return;
        }
        this.minBidDifference = amount;
        if (this.minBidDifference.isEmpty()) {
            this.minBidDifference = this.lastBidAmount.getSmallestValue();
        }
    }

    public PlayerReference getOwner() {
        return this.tradeOwner;
    }

    public boolean isOwner(Player player) {
        return this.tradeOwner != null && this.tradeOwner.is((Entity)player) || LCAdminMode.isAdminPlayer(player);
    }

    @Override
    public boolean allowTradeRule(@Nonnull TradeRule rule) {
        return false;
    }

    public void setDuration(long duration) {
        if (this.isActive()) {
            return;
        }
        this.duration = Math.max(AuctionTradeData.GetMinimumDuration(), duration);
    }

    @Override
    public int getStock(@Nonnull TradeContext context) {
        return this.isValid() ? 1 : 0;
    }

    public List<ItemStack> getAuctionItems() {
        return this.auctionItems;
    }

    public void setAuctionItems(Container auctionItems) {
        if (this.isActive()) {
            return;
        }
        this.auctionItems.clear();
        for (int i = 0; i < auctionItems.m_6643_(); ++i) {
            ItemStack stack = auctionItems.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.auctionItems.add(stack.m_41777_());
        }
    }

    public AuctionTradeData(Player owner) {
        super(false);
        this.tradeOwner = PlayerReference.of(owner);
        this.setDuration(AuctionTradeData.GetDefaultDuration());
    }

    public AuctionTradeData(CompoundTag compound) {
        super(false);
        this.loadFromNBT(compound);
    }

    public AuctionTradeData(PersistentAuctionData data) {
        super(false);
        this.persistentID = data.id;
        this.setDuration(data.duration);
        this.auctionItems = data.getAuctionItems();
        this.setStartingBid(data.getStartingBid());
        this.setMinBidDifferent(data.getMinimumBidDifference());
        this.overtimeAllowed = data.overtimeAllowed();
    }

    public boolean isActive() {
        return this.startTime != 0L && !this.cancelled;
    }

    @Override
    public boolean isValid() {
        if (this.cancelled) {
            return false;
        }
        if (this.auctionItems.isEmpty()) {
            return false;
        }
        if (this.isActive() && this.hasExpired(TimeUtil.getCurrentTime())) {
            return false;
        }
        if (this.getMinBidDifference().isEmpty()) {
            return false;
        }
        return !this.lastBidAmount.isEmpty();
    }

    public void startTimer() {
        if (!this.isActive()) {
            this.startTime = TimeUtil.getCurrentTime();
        }
    }

    public long getRemainingTime(long currentTime) {
        if (!this.isActive()) {
            return this.duration;
        }
        return Math.max(0L, this.startTime + this.duration - currentTime);
    }

    public boolean hasExpired(long time) {
        if (this.isActive()) {
            return time >= this.startTime + this.duration;
        }
        return false;
    }

    public boolean tryMakeBid(AuctionHouseTrader trader, Player player, MoneyValue amount) {
        if (this.cancelled) {
            return false;
        }
        if (!this.validateBidAmount(amount)) {
            return false;
        }
        PlayerReference oldBidder = this.lastBidPlayer;
        if (this.lastBidPlayer != null) {
            AuctionPlayerStorage storage = trader.getStorage(this.lastBidPlayer);
            storage.giveMoney(this.lastBidAmount);
            trader.markStorageDirty();
        }
        this.lastBidPlayer = PlayerReference.of(player);
        this.lastBidAmount = amount;
        if (oldBidder != null) {
            NotificationAPI.API.PushPlayerNotification(oldBidder.id, new AuctionHouseBidNotification(this));
        }
        long currentTime = TimeUtil.getCurrentTime();
        if (this.overtimeAllowed && this.getRemainingTime(currentTime) < 300000L) {
            this.startTime = currentTime;
            this.duration = 300000L;
        }
        return true;
    }

    public boolean validateBidAmount(@Nonnull MoneyValue amount) {
        MoneyValue minAmount = this.getMinNextBid();
        return amount.containsValue(minAmount);
    }

    public MoneyValue getMinNextBid() {
        if (this.lastBidPlayer == null) {
            return this.lastBidAmount;
        }
        return this.lastBidAmount.addValue(this.minBidDifference);
    }

    public void ExecuteTrade(AuctionHouseTrader trader) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        AuctionHouseEvent.AuctionEvent.AuctionCompletedEvent event = new AuctionHouseEvent.AuctionEvent.AuctionCompletedEvent(trader, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (this.lastBidPlayer != null) {
            AuctionPlayerStorage buyerStorage = trader.getStorage(this.lastBidPlayer);
            List<ItemStack> rewards = event.getItems();
            for (ItemStack reward : rewards) {
                buyerStorage.giveItem(reward);
            }
            if (this.tradeOwner != null) {
                AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner);
                sellerStorage.giveMoney(event.getPayment());
            }
            NotificationAPI.API.PushPlayerNotification(this.lastBidPlayer.id, new AuctionHouseBuyerNotification(this));
            if (this.tradeOwner != null) {
                NotificationAPI.API.PushPlayerNotification(this.tradeOwner.id, new AuctionHouseSellerNotification(this));
            }
        } else if (this.tradeOwner != null) {
            AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner);
            List<ItemStack> items = event.getItems();
            for (ItemStack item : items) {
                sellerStorage.giveItem(item);
            }
            NotificationAPI.API.PushPlayerNotification(this.tradeOwner.id, new AuctionHouseSellerNobidNotification(this));
        }
    }

    public void CancelTrade(AuctionHouseTrader trader, boolean giveToPlayer, Player player) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        if (this.lastBidPlayer != null) {
            AuctionPlayerStorage buyerStorage = trader.getStorage(this.lastBidPlayer);
            buyerStorage.giveMoney(this.lastBidAmount);
            NotificationAPI.API.PushPlayerNotification(this.lastBidPlayer.id, new AuctionHouseCancelNotification(this));
        }
        if (giveToPlayer) {
            for (ItemStack stack : this.auctionItems) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            }
        } else if (this.tradeOwner != null) {
            AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner);
            for (ItemStack stack : this.auctionItems) {
                sellerStorage.giveItem(stack);
            }
        }
        AuctionHouseEvent.AuctionEvent.CancelAuctionEvent event = new AuctionHouseEvent.AuctionEvent.CancelAuctionEvent(trader, this, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag itemList = new ListTag();
        for (ItemStack auctionItem : this.auctionItems) {
            itemList.add((Object)auctionItem.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("SellItems", (Tag)itemList);
        compound.m_128365_("LastBid", (Tag)this.lastBidAmount.save());
        if (this.lastBidPlayer != null) {
            compound.m_128365_("LastBidPlayer", (Tag)this.lastBidPlayer.save());
        }
        if (this.minBidDifference != null) {
            compound.m_128365_("MinBid", (Tag)this.minBidDifference.save());
        }
        compound.m_128356_("StartTime", this.startTime);
        compound.m_128356_("Duration", this.duration);
        if (this.tradeOwner != null) {
            compound.m_128365_("TradeOwner", (Tag)this.tradeOwner.save());
        }
        compound.m_128379_("Cancelled", this.cancelled);
        if (!this.persistentID.isBlank()) {
            compound.m_128359_("PersistentID", this.persistentID);
        }
        compound.m_128379_("Overtime", this.overtimeAllowed);
        return compound;
    }

    @Nonnull
    public JsonObject saveToJson(@Nonnull JsonObject json) {
        for (int i = 0; i < this.auctionItems.size(); ++i) {
            json.add("Item" + (i + 1), (JsonElement)FileUtil.convertItemStack(this.auctionItems.get(i)));
        }
        json.addProperty("Duration", (Number)this.duration);
        json.add("StartingBid", (JsonElement)this.lastBidAmount.toJson());
        json.add("MinimumBid", (JsonElement)this.minBidDifference.toJson());
        json.addProperty("Overtime", Boolean.valueOf(this.overtimeAllowed));
        return json;
    }

    @Override
    public void loadFromNBT(@Nonnull CompoundTag compound) {
        ListTag itemList = compound.m_128437_("SellItems", 10);
        this.auctionItems.clear();
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
            if (stack.m_41619_()) continue;
            this.auctionItems.add(stack);
        }
        this.lastBidAmount = MoneyValue.safeLoad(compound, "LastBid");
        this.lastBidPlayer = compound.m_128441_("LastBidPlayer") ? PlayerReference.load(compound.m_128469_("LastBidPlayer")) : null;
        this.minBidDifference = MoneyValue.safeLoad(compound, "MinBid");
        this.startTime = compound.m_128454_("StartTime");
        this.duration = compound.m_128454_("Duration");
        if (compound.m_128425_("TradeOwner", 10)) {
            this.tradeOwner = PlayerReference.load(compound.m_128469_("TradeOwner"));
        }
        this.cancelled = compound.m_128471_("Cancelled");
        if (compound.m_128441_("Overtime")) {
            this.overtimeAllowed = compound.m_128471_("Overtime");
        }
        if (compound.m_128425_("PersistentID", 8)) {
            this.persistentID = compound.m_128461_("PersistentID");
        }
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new AuctionTradeButtonRenderer(this);
    }

    @Override
    public void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        this.openCancelAuctionTab(tab);
    }

    @Override
    public void OnOutputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        this.openCancelAuctionTab(tab);
    }

    @Override
    public void OnInteraction(@Nonnull BasicTradeEditTab tab, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        this.openCancelAuctionTab(tab);
    }

    private void openCancelAuctionTab(BasicTradeEditTab tab) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader ah = (AuctionHouseTrader)traderData;
            int tradeIndex = ah.getTradeIndex(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex));
        }
    }

    @Override
    public TradeDirection getTradeDirection() {
        return TradeDirection.OTHER;
    }

    @Override
    public TradeComparisonResult compare(TradeData otherTrade) {
        return new TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeComparisonResult result) {
        return false;
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        return new ArrayList<Component>();
    }
}

