/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class AuctionPlayerStorage {
    PlayerReference owner;
    private final MoneyStorage storedCoins;
    private final List<ItemStack> storedItems;

    public PlayerReference getOwner() {
        return this.owner;
    }

    public MoneyStorage getStoredCoins() {
        return this.storedCoins;
    }

    public List<ItemStack> getStoredItems() {
        return this.storedItems;
    }

    public AuctionPlayerStorage(PlayerReference player) {
        this.storedCoins = new MoneyStorage(() -> {});
        this.storedItems = new ArrayList<ItemStack>();
        this.owner = player;
    }

    public AuctionPlayerStorage(CompoundTag compound) {
        this.storedCoins = new MoneyStorage(() -> {});
        this.storedItems = new ArrayList<ItemStack>();
        this.load(compound);
    }

    public CompoundTag save(CompoundTag compound) {
        compound.m_128365_("Owner", (Tag)this.owner.save());
        compound.m_128365_("StoredMoney", (Tag)this.storedCoins.save());
        ListTag itemList = new ListTag();
        for (ItemStack storedItem : this.storedItems) {
            itemList.add((Object)storedItem.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("StoredItems", (Tag)itemList);
        return compound;
    }

    protected void load(CompoundTag compound) {
        this.owner = PlayerReference.load(compound.m_128469_("Owner"));
        this.storedCoins.safeLoad(compound, "StoredMoney");
        this.storedItems.clear();
        ListTag itemList = compound.m_128437_("StoredItems", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
            if (stack.m_41619_()) continue;
            this.storedItems.add(stack);
        }
    }

    public void giveMoney(@Nonnull MoneyValue amount) {
        this.storedCoins.addValue(amount);
    }

    public void collectedMoney(Player player) {
        this.storedCoins.GiveToPlayer(player);
    }

    public void giveItem(ItemStack item) {
        if (!item.m_41619_()) {
            this.storedItems.add(item);
        }
    }

    public void removePartial(int itemSlot, int count) {
        if (this.storedItems.size() >= itemSlot || itemSlot < 0) {
            return;
        }
        this.storedItems.get(itemSlot).m_41774_(count);
        if (this.storedItems.get(itemSlot).m_41619_()) {
            this.storedItems.remove(itemSlot);
        }
    }

    public void collectItems(Player player) {
        for (ItemStack stack : this.storedItems) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
        this.storedItems.clear();
    }
}

