/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.text;

import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public final class TextEntryBundle<T> {
    private final Map<T, TextEntry> entryMap;

    public TextEntryBundle(@Nonnull Map<T, TextEntry> map) {
        this.entryMap = ImmutableMap.copyOf(map);
    }

    public static <T> TextEntryBundle<T> of(@Nonnull RegistryObjectBundle<? extends ItemLike, T> bundle) {
        HashMap temp = new HashMap();
        bundle.forEach((L key, RegistryObject<T> item) -> temp.put(key, TextEntry.item((RegistryObject<? extends ItemLike>)item)));
        return new TextEntryBundle(temp);
    }

    public static <T> TextEntryBundle<T> of(@Nonnull RegistryObjectBiBundle<? extends ItemLike, T, ?> bundle) {
        HashMap temp = new HashMap();
        bundle.forEach((L key1, M key2, RegistryObject<T> item) -> temp.put(key1, TextEntry.item((RegistryObject<? extends ItemLike>)item)));
        return new TextEntryBundle(temp);
    }

    public static <T extends Enum<T>> TextEntryBundle<T> of(@Nonnull T[] values, @Nonnull String prefix) {
        HashMap<T, TextEntry> temp = new HashMap<T, TextEntry>();
        for (T key : values) {
            temp.put(key, new TextEntry(prefix + "." + ((Enum)key).name().toLowerCase(Locale.ENGLISH)));
        }
        return new TextEntryBundle(temp);
    }

    public static <T> TextEntryBundle<T> of(@Nonnull List<T> values, @Nonnull String prefix, @Nonnull Function<T, String> getKeyName) {
        HashMap<T, TextEntry> temp = new HashMap<T, TextEntry>();
        for (T key : values) {
            temp.put(key, new TextEntry(prefix + "." + getKeyName.apply(key)));
        }
        return new TextEntryBundle(temp);
    }

    public TextEntry get(@Nonnull T key) {
        return this.entryMap.get(key);
    }

    public void forEach(@Nonnull BiConsumer<T, TextEntry> consumer) {
        this.entryMap.forEach(consumer);
    }
}

