/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.text;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.stats.StatKey;
import io.github.lightman314.lightmanscurrency.api.stats.StatType;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public final class TextEntry {
    private final Supplier<String> key;

    public String getKey() {
        return this.key.get();
    }

    public TextEntry(@Nonnull String key) {
        this.key = () -> key;
    }

    public TextEntry(@Nonnull Supplier<String> key) {
        this.key = Suppliers.memoize(key::get);
    }

    @Nonnull
    public MutableComponent get(Object ... objects) {
        return Component.m_237110_((String)this.getKey(), (Object[])objects);
    }

    public MutableComponent getWithStyle(ChatFormatting ... format) {
        return Component.m_237115_((String)this.getKey()).m_130944_(format);
    }

    public List<Component> getAsList(Object ... objects) {
        return Lists.newArrayList((Object[])new Component[]{this.get(objects)});
    }

    public List<Component> getAsListWithStyle(ChatFormatting ... format) {
        return Lists.newArrayList((Object[])new Component[]{this.getWithStyle(format)});
    }

    public void tooltip(@Nonnull List<Component> tooltip, Object ... objects) {
        tooltip.add((Component)this.get(objects));
    }

    @Nonnull
    public IconData icon(Object ... objects) {
        return IconData.of((Component)this.get(objects));
    }

    public static TextEntry item(@Nonnull RegistryObject<? extends ItemLike> item) {
        return new TextEntry(() -> ((ItemLike)item.get()).m_5456_().m_5524_());
    }

    public static TextEntry block(@Nonnull RegistryObject<? extends Block> block) {
        return new TextEntry(() -> ((Block)block.get()).m_7705_());
    }

    public static TextEntry block(@Nonnull Supplier<? extends Block> block) {
        return new TextEntry(() -> ((Block)block.get()).m_7705_());
    }

    public static TextEntry enchantment(@Nonnull RegistryObject<? extends Enchantment> enchantment) {
        return new TextEntry(() -> ((Enchantment)enchantment.get()).m_44704_());
    }

    public static TextEntry gamerule(@Nonnull String ruleKey) {
        return new TextEntry("gamerule." + ruleKey);
    }

    public static TextEntry profession(@Nonnull RegistryObject<? extends VillagerProfession> profession) {
        return new TextEntry(() -> {
            ResourceLocation id = ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)((VillagerProfession)profession.get()));
            return "entity.minecraft.villager." + id.m_135827_() + "." + id.m_135815_();
        });
    }

    public static TextEntry creativeTab(@Nonnull String modid, @Nonnull String name) {
        return new TextEntry("itemGroup." + modid + "." + name);
    }

    public static TextEntry keyBind(@Nonnull String modid, @Nonnull String name) {
        return new TextEntry("key." + modid + "." + name);
    }

    public static TextEntry sound(@Nonnull String modid, @Nonnull String name) {
        return new TextEntry(modid + ".subtitle." + name);
    }

    public static TextEntry tooltip(@Nonnull String modid, @Nonnull String key) {
        return new TextEntry("tooltip." + modid + "." + key);
    }

    public static TextEntry gui(@Nonnull String modid, @Nonnull String key) {
        return new TextEntry("gui." + modid + "." + key);
    }

    public static TextEntry button(@Nonnull String modid, @Nonnull String key) {
        return new TextEntry("button." + modid + "." + key);
    }

    public static TextEntry widget(@Nonnull String modid, @Nonnull String key) {
        return new TextEntry("widget." + modid + "." + key);
    }

    public static TextEntry message(@Nonnull String modid, @Nonnull String key) {
        return new TextEntry("message." + modid + "." + key);
    }

    public static TextEntry blurb(@Nonnull String modid, @Nonnull String key) {
        return new TextEntry("blurb." + modid + "." + key);
    }

    public static TextEntry command(@Nonnull String modid, @Nonnull String key) {
        return new TextEntry("command." + modid + "." + key);
    }

    public static TextEntry argument(@Nonnull String key) {
        return new TextEntry("command.argument." + key);
    }

    public static TextEntry description(@Nonnull TextEntry parent) {
        return TextEntry.extend(parent, "desc");
    }

    public static TextEntry plural(@Nonnull TextEntry parent) {
        return TextEntry.extend(parent, "plural");
    }

    public static TextEntry initial(@Nonnull TextEntry parent) {
        return TextEntry.extend(parent, "initial");
    }

    public static TextEntry tradeRule(@Nonnull TradeRuleType<?> type) {
        return new TextEntry(TradeRule.translationKeyOfType(type.type));
    }

    public static TextEntry tradeRuleMessage(@Nonnull TradeRuleType<?> type, @Nonnull String message) {
        return new TextEntry(TradeRule.translationKeyOfType(type.type) + "." + message);
    }

    public static TextEntry notification(@Nonnull NotificationType<?> type) {
        return TextEntry.notification(type.type);
    }

    public static TextEntry notification(@Nonnull ResourceLocation type) {
        return new TextEntry("notification." + type.m_135827_() + "." + type.m_135815_());
    }

    public static TextEntry notification(@Nonnull NotificationType<?> type, @Nonnull String extra) {
        return TextEntry.notification(type.type, extra);
    }

    public static TextEntry notification(@Nonnull ResourceLocation type, @Nonnull String extra) {
        return new TextEntry("notification." + type.m_135827_() + "." + type.m_135815_() + "." + extra);
    }

    public static TextEntry dataName(@Nonnull String modid, @Nonnull String key) {
        return new TextEntry("data." + modid + ".name." + key);
    }

    public static TextEntry dataCategory(@Nonnull String modid, @Nonnull String key) {
        return new TextEntry("data." + modid + ".category." + key);
    }

    public static TextEntry chain(@Nonnull String chain) {
        return new TextEntry("lightmanscurrency.money.chain." + chain);
    }

    public static TextEntry chainDisplay(@Nonnull String chain) {
        return new TextEntry("lightmanscurrency.money.chain." + chain + ".display");
    }

    public static TextEntry chainDisplayWordy(@Nonnull String chain) {
        return new TextEntry("lightmanscurrency.money.chain." + chain + ".display.wordy");
    }

    public static TextEntry lcStat(@Nonnull StatKey<?, ?> statKey) {
        return new TextEntry(StatType.getTranslationKey(statKey.key));
    }

    public static TextEntry reiGroup(@Nonnull String modid, @Nonnull String type) {
        return new TextEntry("rei." + modid + ".group." + type);
    }

    public static TextEntry jeiInfo(@Nonnull String modid, @Nonnull String type) {
        return new TextEntry("jei." + modid + ".info." + type);
    }

    public static TextEntry curiosSlot(@Nonnull String type) {
        return new TextEntry("curios.identifier." + type);
    }

    public static TextEntry extend(@Nonnull TextEntry parent, @Nonnull String extra) {
        return new TextEntry(() -> parent.getKey() + "." + extra);
    }

    public String toString() {
        return this.get(new Object[0]).getString();
    }
}

