/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;

public class AddRemoveAllyNotification
extends SingleLineNotification {
    public static final NotificationType<AddRemoveAllyNotification> TYPE = new NotificationType(VersionUtil.lcResource("add_remove_ally"), AddRemoveAllyNotification::new);
    PlayerReference player;
    boolean isAdd;
    PlayerReference ally;

    private AddRemoveAllyNotification() {
    }

    public AddRemoveAllyNotification(PlayerReference player, boolean isAdd, PlayerReference ally) {
        this.player = player;
        this.isAdd = isAdd;
        this.ally = ally;
    }

    @Nonnull
    protected NotificationType<AddRemoveAllyNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return LCText.NOTIFICATION_SETTINGS_ADD_REMOVE_ALLY.get(this.player.getName(true), this.isAdd ? LCText.GUI_ADDED.get(new Object[0]) : LCText.GUI_REMOVED.get(new Object[0]), this.ally.getName(true), this.isAdd ? LCText.GUI_TO.get(new Object[0]) : LCText.GUI_FROM.get(new Object[0]));
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128379_("Add", this.isAdd);
        compound.m_128365_("Ally", (Tag)this.ally.save());
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.isAdd = compound.m_128471_("Add");
        this.ally = PlayerReference.load(compound.m_128469_("Ally"));
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof AddRemoveAllyNotification) {
            AddRemoveAllyNotification n = (AddRemoveAllyNotification)other;
            return n.player.is(this.player) && n.isAdd == this.isAdd && n.ally.is(this.ally);
        }
        return false;
    }
}

