/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class DepositWithdrawNotification
extends SingleLineNotification {
    public static final NotificationType<Player> PLAYER_TYPE = new NotificationType(VersionUtil.lcResource("bank_deposit_player"), DepositWithdrawNotification::createPlayer);
    public static final NotificationType<Custom> CUSTOM_TYPE = new NotificationType(VersionUtil.lcResource("bank_deposit_trader"), DepositWithdrawNotification::createTrader);
    public static final NotificationType<Server> SERVER_TYPE = new NotificationType(VersionUtil.lcResource("bank_deposit_server"), DepositWithdrawNotification::createServer);
    protected MutableComponent accountName;
    protected boolean isDeposit;
    protected MoneyValue amount = MoneyValue.empty();

    protected DepositWithdrawNotification(MutableComponent accountName, boolean isDeposit, MoneyValue amount) {
        this.accountName = accountName;
        this.isDeposit = isDeposit;
        this.amount = amount;
    }

    protected DepositWithdrawNotification() {
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.accountName));
        compound.m_128379_("Deposit", this.isDeposit);
        compound.m_128365_("Amount", (Tag)this.amount.save());
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.accountName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        this.isDeposit = compound.m_128471_("Deposit");
        this.amount = MoneyValue.safeLoad(compound, "Amount");
    }

    protected abstract MutableComponent getName();

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return LCText.NOTIFICATION_BANK_DEPOSIT_WITHDRAW.get(this.getName(), this.isDeposit ? LCText.NOTIFICATION_BANK_DEPOSIT.get(new Object[0]) : LCText.NOTIFICATION_BANK_WITHDRAW.get(new Object[0]), this.amount.getText());
    }

    private static Player createPlayer() {
        return new Player();
    }

    private static Custom createTrader() {
        return new Custom();
    }

    private static Server createServer() {
        return new Server();
    }

    public static class Player
    extends DepositWithdrawNotification {
        PlayerReference player;

        private Player() {
        }

        public Player(PlayerReference player, MutableComponent accountName, boolean isDeposit, MoneyValue amount) {
            super(accountName, isDeposit, amount);
            this.player = player;
        }

        @Override
        protected MutableComponent getName() {
            return this.player.getNameComponent(true);
        }

        @Nonnull
        protected NotificationType<Player> getType() {
            return PLAYER_TYPE;
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128365_("Player", (Tag)this.player.save());
        }

        @Override
        protected void loadAdditional(@Nonnull CompoundTag compound) {
            super.loadAdditional(compound);
            this.player = PlayerReference.load(compound.m_128469_("Player"));
        }

        @Override
        protected boolean canMerge(@Nonnull Notification other) {
            if (other instanceof Player) {
                Player n = (Player)other;
                return n.accountName.equals((Object)this.accountName) && n.isDeposit == this.isDeposit && n.amount.equals(this.amount) && n.player.is(this.player);
            }
            return false;
        }
    }

    public static class Custom
    extends DepositWithdrawNotification {
        MutableComponent objectName;

        private Custom() {
        }

        public Custom(String objectName, MutableComponent accountName, boolean isDeposit, MoneyValue amount) {
            this(EasyText.literal(objectName), accountName, isDeposit, amount);
        }

        public Custom(MutableComponent objectName, MutableComponent accountName, boolean isDeposit, MoneyValue amount) {
            super(accountName, isDeposit, amount);
            this.objectName = objectName;
        }

        @Override
        protected MutableComponent getName() {
            return this.objectName;
        }

        @Nonnull
        protected NotificationType<Custom> getType() {
            return CUSTOM_TYPE;
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128359_("Trader", Component.Serializer.m_130703_((Component)this.objectName));
        }

        @Override
        protected void loadAdditional(@Nonnull CompoundTag compound) {
            super.loadAdditional(compound);
            this.objectName = Component.Serializer.m_130701_((String)compound.m_128461_("Trader"));
        }

        @Override
        protected boolean canMerge(@Nonnull Notification other) {
            if (other instanceof Custom) {
                Custom n = (Custom)other;
                return n.accountName.equals((Object)this.accountName) && n.isDeposit == this.isDeposit && n.amount.equals(this.amount) && n.objectName.equals((Object)this.objectName);
            }
            return false;
        }
    }

    public static class Server
    extends DepositWithdrawNotification {
        private Server() {
        }

        private Server(MutableComponent accountName, boolean isDeposit, MoneyValue amount) {
            super(accountName, isDeposit, amount);
        }

        public static Supplier<Notification> create(@Nonnull MutableComponent accountName, boolean isDeposit, @Nonnull MoneyValue amount) {
            return () -> new Server(accountName, isDeposit, amount);
        }

        @Override
        protected MutableComponent getName() {
            return LCText.NOTIFICATION_BANK_DEPOSIT_WITHDRAW_SERVER.get(new Object[0]);
        }

        @Nonnull
        protected NotificationType<Server> getType() {
            return SERVER_TYPE;
        }

        @Override
        protected boolean canMerge(@Nonnull Notification other) {
            return false;
        }
    }
}

