/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.auction;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.data.ItemData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseNotification;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AuctionHouseBuyerNotification
extends AuctionHouseNotification {
    public static final NotificationType<AuctionHouseBuyerNotification> TYPE = new NotificationType(VersionUtil.lcResource("auction_house_buyer"), AuctionHouseBuyerNotification::new);
    List<ItemData> items;
    MoneyValue cost = MoneyValue.empty();

    private AuctionHouseBuyerNotification() {
    }

    public AuctionHouseBuyerNotification(AuctionTradeData trade) {
        this.cost = trade.getLastBidAmount();
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < trade.getAuctionItems().size(); ++i) {
            this.items.add(new ItemData(trade.getAuctionItems().get(i)));
        }
    }

    @Nonnull
    protected NotificationType<AuctionHouseBuyerNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        Component itemText = ItemData.getItemNames(this.items);
        MutableComponent cost = this.cost.getText("0");
        return LCText.NOTIFICATION_AUCTION_BUYER.get(itemText, cost);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        ListTag itemList = new ListTag();
        for (ItemData item : this.items) {
            itemList.add((Object)item.save());
        }
        compound.m_128365_("Items", (Tag)itemList);
        compound.m_128365_("Price", (Tag)this.cost.save());
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        ListTag itemList = compound.m_128437_("Items", 10);
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(ItemData.load(itemList.m_128728_(i)));
        }
        this.cost = MoneyValue.safeLoad(compound, "Price");
    }
}

