/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStatsClientTab;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;

public class TraderStatsTab
extends TraderStorageTab {
    public TraderStatsTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    public Object createClientTab(@Nonnull Object screen) {
        return new TraderStatsClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).hasPermission("viewLogs");
    }

    public void clearStats(boolean fullClear) {
        if (((ITraderStorageMenu)this.menu).hasPermission("editSettings")) {
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setBoolean("ClearStats", fullClear));
            } else {
                TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
                if (trader != null) {
                    trader.statTracker.clear(fullClear);
                    trader.markStatsDirty();
                }
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("ClearStats")) {
            this.clearStats(message.getBoolean("ClearStats"));
        }
    }
}

