/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.teams.tabs;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamNameAndOwnerClientTab;
import io.github.lightman314.lightmanscurrency.common.data.types.TeamDataCache;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.teams.TeamManagementTab;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import javax.annotation.Nonnull;

public class TeamNameAndOwnerTab
extends TeamManagementTab.Management {
    public TeamNameAndOwnerTab(@Nonnull TeamManagementMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    public Object createClientTab(@Nonnull Object screen) {
        return new TeamNameAndOwnerClientTab(screen, this);
    }

    @Override
    @Nonnull
    protected TeamManagementTab.Management.AccessLevel accessLevel() {
        return TeamManagementTab.Management.AccessLevel.ADMINS;
    }

    public void ChangeName(@Nonnull String newName) {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team instanceof Team) {
            Team t = (Team)team;
            t.changeName(((TeamManagementMenu)this.menu).player, newName);
        }
        if (this.isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setString("ChangeName", newName));
        }
    }

    public void SetOwner(@Nonnull PlayerReference owner) {
        if (this.isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setCompound("SetOwner", owner.save()));
        } else {
            ITeam iTeam = ((TeamManagementMenu)this.menu).selectedTeam();
            if (iTeam instanceof Team) {
                Team team = (Team)iTeam;
                team.changeOwner(((TeamManagementMenu)this.menu).player, owner);
            }
        }
    }

    public void DisbandTeam() {
        if (this.isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setFlag("DisbandTeam"));
        } else {
            ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
            if (team != null && team.isOwner(((TeamManagementMenu)this.menu).player)) {
                TeamDataCache data = TeamDataCache.TYPE.get(false);
                if (data == null) {
                    return;
                }
                data.removeTeam(team.getID());
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("ChangeName")) {
            this.ChangeName(message.getString("ChangeName"));
        }
        if (message.contains("SetOwner")) {
            this.SetOwner(PlayerReference.load(message.getNBT("SetOwner")));
        }
        if (message.contains("DisbandTeam")) {
            this.DisbandTeam();
        }
    }
}

