/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.teams.tabs;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamBankAccountClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.teams.TeamManagementTab;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import javax.annotation.Nonnull;

public class TeamBankAccountTab
extends TeamManagementTab.Management {
    public TeamBankAccountTab(@Nonnull TeamManagementMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    public Object createClientTab(@Nonnull Object screen) {
        return new TeamBankAccountClientTab(screen, this);
    }

    @Override
    @Nonnull
    protected TeamManagementTab.Management.AccessLevel accessLevel() {
        return TeamManagementTab.Management.AccessLevel.OWNER;
    }

    public void CreateBankAccount() {
        if (this.isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setFlag("CreateBankAccount"));
        } else {
            ITeam iTeam = ((TeamManagementMenu)this.menu).selectedTeam();
            if (iTeam instanceof Team) {
                Team team = (Team)iTeam;
                team.createBankAccount(((TeamManagementMenu)this.menu).player);
            }
        }
    }

    public void ChangeBankAccess(int level) {
        if (this.isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setInt("ChangeBankAccess", level));
        } else {
            ITeam iTeam = ((TeamManagementMenu)this.menu).selectedTeam();
            if (iTeam instanceof Team) {
                Team team = (Team)iTeam;
                team.changeBankLimit(((TeamManagementMenu)this.menu).player, Owner.validateNotificationLevel(level));
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("CreateBankAccount")) {
            this.CreateBankAccount();
        }
        if (message.contains("ChangeBankAccess")) {
            this.ChangeBankAccess(message.getInt("ChangeBankAccess"));
        }
    }
}

