/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.menus.MoneySlot;
import io.github.lightman314.lightmanscurrency.api.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.api.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.IMoneyCollectionMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.customer.ITraderMenu;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.slots.InteractionSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TraderMenu
extends EasyMenu
implements IValidatedMenu,
ITraderMenu,
IMoneyCollectionMenu {
    private final Supplier<ITraderSource> traderSource;
    private final Map<Long, TradeContext> contextCache = new HashMap<Long, TradeContext>();
    public static final int SLOT_OFFSET = 15;
    InteractionSlot interactionSlot;
    private final Container coins;
    List<Slot> coinSlots = new ArrayList<Slot>();
    private final MenuValidator validator;

    @Override
    @Nullable
    public ITraderSource getTraderSource() {
        return this.traderSource.get();
    }

    @Override
    @Nonnull
    public Player getPlayer() {
        return this.player;
    }

    @Override
    @Nonnull
    public List<Slot> getSlots() {
        return ImmutableList.copyOf((Collection)this.f_38839_);
    }

    @Override
    @Nonnull
    public ItemStack getHeldItem() {
        return this.m_142621_();
    }

    @Override
    public void setHeldItem(@Nonnull ItemStack stack) {
        this.m_142503_(stack);
    }

    public InteractionSlot getInteractionSlot() {
        return this.interactionSlot;
    }

    public List<Slot> getCoinSlots() {
        return this.coinSlots;
    }

    @Override
    @Nonnull
    public MenuValidator getValidator() {
        return this.validator;
    }

    public TraderMenu(int windowID, Inventory inventory, long traderID, MenuValidator validator) {
        this((MenuType)ModMenus.TRADER.get(), windowID, inventory, () -> TraderAPI.API.GetTrader(IClientTracker.entityWrapper((Entity)inventory.f_35978_), traderID), validator);
    }

    protected TraderMenu(MenuType<?> type, int windowID, Inventory inventory, Supplier<ITraderSource> traderSource, MenuValidator validator) {
        super(type, windowID, inventory);
        this.validator = validator;
        this.traderSource = traderSource;
        this.coins = new SimpleContainer(5);
        this.addValidator(this::traderSourceValid);
        this.addValidator(this.validator);
        this.init(inventory);
        for (TraderData trader : this.traderSource.get().getTraders()) {
            if (trader == null) continue;
            trader.userOpen(this.player);
        }
    }

    @Override
    @Nonnull
    public TradeContext getContext(@Nullable TraderData trader) {
        long traderID;
        long l = traderID = trader == null ? -1L : trader.getID();
        if (!this.contextCache.containsKey(traderID) || this.contextCache.get(traderID).getTrader() != trader) {
            this.contextCache.put(traderID, TradeContext.create(trader, this.player).withCoinSlots(this.coins).withInteractionSlot(this.interactionSlot).build());
        }
        return this.contextCache.get(traderID);
    }

    protected void init(Inventory inventory) {
        int x;
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, 23 + x2 * 18, 154 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 23 + x * 18, 212));
        }
        for (x = 0; x < this.coins.m_6643_(); ++x) {
            this.coinSlots.add(this.m_38897_(new MoneySlot(this.coins, x, 23 + (x + 4) * 18, 122, this.player)));
        }
        ArrayList<InteractionSlotData> slotData = new ArrayList<InteractionSlotData>();
        for (TraderData trader : this.traderSource.get().getTraders()) {
            trader.addInteractionSlots(slotData);
        }
        this.interactionSlot = new InteractionSlot(slotData, 23, 122);
        this.m_38897_(this.interactionSlot);
    }

    private boolean traderSourceValid() {
        return this.traderSource != null && this.traderSource.get() != null && this.traderSource.get().getTraders() != null && !this.traderSource.get().getTraders().isEmpty();
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.coins);
        this.m_150411_(player, this.interactionSlot.f_40218_);
        if (this.traderSource.get() != null) {
            for (TraderData trader : this.traderSource.get().getTraders()) {
                if (trader == null) continue;
                trader.userClose(this.player);
            }
        }
    }

    public void ExecuteTrade(int traderIndex, int tradeIndex) {
        ITraderSource traderSource = this.traderSource.get();
        if (traderSource == null) {
            this.player.m_6915_();
            return;
        }
        List<TraderData> traderList = traderSource.getTraders();
        if (traderIndex >= 0 && traderIndex < traderList.size()) {
            TraderData trader = traderSource.getTraders().get(traderIndex);
            if (trader == null) {
                LightmansCurrency.LogWarning("Trader at index " + traderIndex + " is null.");
                return;
            }
            TradeResult result = trader.TryExecuteTrade(this.getContext(trader), tradeIndex);
            if (result.hasMessage()) {
                LightmansCurrency.LogDebug(result.getMessage().getString());
            }
        } else {
            LightmansCurrency.LogWarning("Trader " + traderIndex + " is not a valid trader index.");
        }
    }

    public boolean isSingleTrader() {
        ITraderSource tradeSource = this.traderSource.get();
        if (tradeSource == null) {
            this.player.m_6915_();
            return false;
        }
        return tradeSource.isSingleTrader() && tradeSource.getTraders().size() == 1;
    }

    public TraderData getSingleTrader() {
        if (this.isSingleTrader()) {
            return this.traderSource.get().getSingleTrader();
        }
        return null;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < 36 ? !this.m_38903_(slotStack, 36, this.f_38839_.size(), false) : index < this.f_38839_.size() && !this.m_38903_(slotStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    @Override
    public void CollectStoredMoney() {
        if (this.isSingleTrader()) {
            LightmansCurrency.LogInfo("Attempting to collect coins from trader.");
            TraderData trader = this.getSingleTrader();
            trader.CollectStoredMoney(this.player);
        }
    }

    public static class TraderMenuAllNetwork
    extends TraderMenu {
        public TraderMenuAllNetwork(int windowID, Inventory inventory, MenuValidator validator) {
            super((MenuType)ModMenus.TRADER_NETWORK_ALL.get(), windowID, inventory, ITraderSource.NetworkTraderSource(inventory.f_35978_.m_9236_().f_46443_), validator);
        }
    }

    public static class TraderMenuBlockSource
    extends TraderMenu {
        public TraderMenuBlockSource(int windowID, Inventory inventory, BlockPos pos, MenuValidator validator) {
            super((MenuType)ModMenus.TRADER_BLOCK.get(), windowID, inventory, () -> {
                BlockEntity patt8180$temp = inventory.f_35978_.m_9236_().m_7702_(pos);
                if (patt8180$temp instanceof ITraderSource) {
                    ITraderSource source = (ITraderSource)patt8180$temp;
                    return source;
                }
                return null;
            }, validator);
        }
    }
}

