/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.blockentity.TicketStationBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeTypes;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketMaterialSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketModifierSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class TicketStationMenu
extends LazyMessageMenu {
    private final Container output = new SimpleContainer(1);
    public final TicketStationBlockEntity blockEntity;

    public static List<TicketStationRecipe> getAllRecipes(@Nonnull Level level) {
        return level.m_7465_().m_44013_((RecipeType)RecipeTypes.TICKET.get());
    }

    public List<TicketStationRecipe> getAllRecipes() {
        return TicketStationMenu.getAllRecipes(this.blockEntity.m_58904_());
    }

    public TicketStationRecipe getRecipe(@Nonnull ResourceLocation recipeID) {
        for (TicketStationRecipe recipe : this.getAllRecipes()) {
            if (!recipe.m_6423_().equals((Object)recipeID)) continue;
            return recipe;
        }
        return null;
    }

    public TicketStationMenu(int windowId, Inventory inventory, TicketStationBlockEntity blockEntity) {
        super((MenuType)ModMenus.TICKET_MACHINE.get(), windowId, inventory);
        this.blockEntity = blockEntity;
        this.addValidator(BlockEntityValidator.of(this.blockEntity));
        this.m_38897_(new TicketModifierSlot(this, this.blockEntity.getStorage(), 0, 20, 21));
        this.m_38897_(new TicketMaterialSlot(this, this.blockEntity.getStorage(), 1, 56, 21));
        this.m_38897_(new OutputSlot(this.output, 0, 116, 21));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 56 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 114));
        }
    }

    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, this.output);
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            int totalSize = this.blockEntity.getStorage().m_6643_() + this.output.m_6643_();
            if (index < totalSize ? !this.m_38903_(slotStack, totalSize, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.blockEntity.getStorage().m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean validInputs() {
        return this.getAllRecipes().stream().anyMatch(r -> r.m_5818_(this.blockEntity.getStorage(), this.blockEntity.m_58904_()));
    }

    public boolean roomForOutput(TicketStationRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack outputStack = this.output.m_8020_(0);
        if (outputStack.m_41619_()) {
            return true;
        }
        return InventoryUtil.ItemMatches(recipe.peekAtResult(this.blockEntity.getStorage()), outputStack) && outputStack.m_41741_() > outputStack.m_41613_();
    }

    public void craftTickets(boolean fullStack, @Nonnull ResourceLocation recipeID) {
        TicketStationRecipe recipe = this.getRecipe(recipeID);
        if (recipe == null) {
            return;
        }
        if (!recipe.m_5818_(this.blockEntity.getStorage(), this.blockEntity.m_58904_())) {
            return;
        }
        if (!this.roomForOutput(recipe)) {
            LightmansCurrency.LogDebug("No room for Ticket Machine outputs. Cannot craft tickets.");
            return;
        }
        int amountToCraft = 1;
        if (fullStack) {
            amountToCraft = this.output.m_6893_();
        }
        for (int i = 0; i < amountToCraft; ++i) {
            if (!this.assemble(recipe)) continue;
            return;
        }
    }

    private boolean assemble(@Nonnull TicketStationRecipe recipe) {
        ItemStack result;
        if (this.roomForOutput(recipe) && recipe.m_5818_(this.blockEntity.getStorage(), this.blockEntity.m_58904_()) && !(result = recipe.m_5874_(this.blockEntity.getStorage(), this.blockEntity.m_58904_().m_9598_())).m_41619_() && InventoryUtil.PutItemStack(this.output, result)) {
            if (recipe.consumeModifier()) {
                this.blockEntity.getStorage().m_7407_(0, 1);
            }
            this.blockEntity.getStorage().m_7407_(1, 1);
            return false;
        }
        return true;
    }

    public void SendCraftTicketsMessage(boolean fullStack, @Nonnull ResourceLocation recipe) {
        this.SendMessageToServer(LazyPacketData.builder().setBoolean("CraftTickets", fullStack).setResourceLocation("Recipe", recipe));
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        if (message.contains("CraftTickets")) {
            this.craftTickets(message.getBoolean("CraftTickets"), message.getResourceLocation("Recipe"));
        }
    }
}

