/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.common.core.ModLootPoolEntryTypes;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VanillaLootTableReference
extends LootPoolSingletonContainer {
    final ResourceLocation name;

    private VanillaLootTableReference(ResourceLocation name, int weight, int quality, LootItemCondition[] condition, LootItemFunction[] functions) {
        super(weight, quality, condition, functions);
        this.name = name;
    }

    public LootPoolEntryType m_6751_() {
        return (LootPoolEntryType)ModLootPoolEntryTypes.VANILLA_LOOT_TABLE.get();
    }

    public void m_6948_(@Nonnull Consumer<ItemStack> consumer, @Nonnull LootContext context) {
        LootTable table = context.m_278643_().m_278676_(this.name);
        table.m_79131_(context, consumer);
    }

    public void m_6165_(ValidationContext context) {
        LootDataId table = new LootDataId(LootDataType.f_278413_, this.name);
        if (context.m_278820_(table)) {
            context.m_79357_("Table " + this.name + " is recursively called");
        } else {
            super.m_6165_(context);
            context.m_278720_().m_278739_(table).ifPresent(t -> t.m_79136_(context.m_278632_("->{" + this.name + "}", table)));
        }
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableReference(ResourceLocation name) {
        if (!BuiltInLootTables.m_78766_().contains(name)) {
            throw new IllegalArgumentException(name + " is not a valid vanilla loot table!");
        }
        return VanillaLootTableReference.m_79687_((weight, quality, conditions, functions) -> new VanillaLootTableReference(name, weight, quality, conditions, functions));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<VanillaLootTableReference> {
        public void serializeCustom(JsonObject json, VanillaLootTableReference entry, JsonSerializationContext context) {
            super.m_7219_(json, (LootPoolSingletonContainer)entry, context);
            json.addProperty("name", entry.name.toString());
        }

        protected VanillaLootTableReference deserialize(JsonObject json, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            ResourceLocation name = VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"name"));
            if (!BuiltInLootTables.m_78766_().contains(name)) {
                throw new JsonSyntaxException(name + " is not a valid vanilla loot table!");
            }
            return new VanillaLootTableReference(name, weight, quality, conditions, functions);
        }
    }
}

