/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.common.core.ModLootPoolEntryTypes;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AncientCoinLoot
extends LootPoolSingletonContainer {
    private final AncientCoinType type;

    protected AncientCoinLoot(@Nonnull AncientCoinType type, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.type = type;
    }

    protected void m_6948_(@Nonnull Consumer<ItemStack> consumer, @Nonnull LootContext lootContext) {
        consumer.accept(this.type.asItem());
    }

    @Nonnull
    public LootPoolEntryType m_6751_() {
        return (LootPoolEntryType)ModLootPoolEntryTypes.ANCIENT_COIN_TYPE.get();
    }

    public static LootPoolSingletonContainer.Builder<?> ancientCoin(@Nonnull AncientCoinType type) {
        return AncientCoinLoot.m_79687_((p_79583_, p_79584_, p_79585_, p_79586_) -> new AncientCoinLoot(type, p_79583_, p_79584_, p_79585_, p_79586_));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<AncientCoinLoot> {
        public void serializeCustom(@Nonnull JsonObject json, @Nonnull AncientCoinLoot entry, @Nonnull JsonSerializationContext context) {
            super.m_7219_(json, (LootPoolSingletonContainer)entry, context);
            json.addProperty("coin", entry.type.toString());
        }

        @Nonnull
        protected AncientCoinLoot deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context, int weight, int quality, @Nonnull LootItemCondition[] conditions, @Nonnull LootItemFunction[] functions) {
            AncientCoinType type = (AncientCoinType)EnumUtil.enumFromString((String)GsonHelper.m_13906_((JsonObject)json, (String)"coin"), (Enum[])AncientCoinType.values(), null);
            if (type == null) {
                throw new JsonSyntaxException(GsonHelper.m_13906_((JsonObject)json, (String)"coin") + " is not a valid ancient coin type!");
            }
            return new AncientCoinLoot(type, weight, quality, conditions, functions);
        }
    }
}

