/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.cards;

import io.github.lightman314.lightmanscurrency.api.capability.money.MoneyHandler;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.ISidedObject;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.DepositWithdrawNotification;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ATMCardMoneyHandler
extends MoneyHandler
implements ISidedObject {
    private boolean isClient = false;
    private final ItemStack card;

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    public ATMCardMoneyHandler(@Nonnull ItemStack card) {
        this.card = card;
    }

    private MutableComponent getCardName() {
        return EasyText.makeMutable(this.card.m_41786_());
    }

    @Override
    @Nonnull
    public ATMCardMoneyHandler flagAsClient() {
        this.isClient = true;
        return this;
    }

    @Override
    @Nonnull
    public ATMCardMoneyHandler flagAsClient(boolean isClient) {
        this.isClient = isClient;
        return this;
    }

    @Override
    @Nonnull
    public ATMCardMoneyHandler flagAsClient(@Nonnull IClientTracker tracker) {
        this.isClient = tracker.isClient();
        return this;
    }

    @Nullable
    protected IBankAccount getAccount() {
        CompoundTag tag = this.card.m_41784_();
        BankReference reference = null;
        if (tag.m_128441_("BankAccount")) {
            reference = BankReference.load(tag.m_128469_("BankAccount")).flagAsClient(this);
        }
        if (reference != null) {
            int validation;
            IBankAccount account = reference.get();
            int n = validation = tag.m_128441_("AccountValidation") ? tag.m_128451_("AccountValidation") : -1;
            if (account != null && account.isCardValid(validation)) {
                return account;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
        IBankAccount account = this.getAccount();
        if (account != null) {
            if (!simulation) {
                account.depositMoney(insertAmount);
                account.pushLocalNotification(new DepositWithdrawNotification.Custom(this.getCardName(), account.getName(), true, insertAmount));
            }
            return MoneyValue.empty();
        }
        return insertAmount;
    }

    @Override
    @Nonnull
    public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
        IBankAccount account = this.getAccount();
        if (account != null) {
            MoneyValue result = account.getMoneyStorage().extractMoney(extractAmount, simulation);
            MoneyValue amountTaken = extractAmount.subtractValue(result);
            if (!amountTaken.isEmpty() && !simulation) {
                account.pushLocalNotification(new DepositWithdrawNotification.Custom(this.getCardName(), account.getName(), false, amountTaken));
            }
            return result;
        }
        return extractAmount;
    }

    @Override
    public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
        return true;
    }

    @Override
    protected void collectStoredMoney(@Nonnull MoneyView.Builder builder) {
        IBankAccount account = this.getAccount();
        if (account != null) {
            builder.merge(account.getMoneyStorage());
        }
    }
}

