/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.CapabilityMoneyViewer;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyViewer;
import io.github.lightman314.lightmanscurrency.common.capability.MixedCapabilityProvider;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletMoneyViewer;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.enchantments.WalletEnchantment;
import io.github.lightman314.lightmanscurrency.common.items.data.SoundEntry;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.SPacketSyncWallet;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ListUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class WalletItem
extends Item {
    private static final SoundEvent emptyOpenSound = SoundEvents.f_11678_;
    public static final int LARGEST_LEVEL = 6;
    public static final int CONFIG_LIMIT = 7;
    public static final int MAX_WALLET_SLOTS = 78;
    public static final int SLOTS_PER_UPGRADE = 6;
    public static final int DEFAULT_UPGRADE_LIMIT = 24;
    public static final ResourceLocation DEFAULT_COIN_COLLECT_SOUND = VersionUtil.lcResource("coins_clinking");
    private final int level;
    private final int storageSize;
    private final int bonusMagnet;
    public final boolean indestructible;
    public final ResourceLocation model;
    public final int upgradeLimit;
    private final List<SoundEntry> coinCollectSound;

    @Nonnull
    public static ResourceLocation lazyModel(@Nonnull String itemID) {
        return WalletItem.lazyModel(VersionUtil.lcResource(itemID));
    }

    @Nonnull
    public static ResourceLocation lazyModel(@Nonnull ResourceLocation itemID) {
        return itemID.m_246208_("item/wallet_hip/");
    }

    public WalletItem(int level, int storageSize, @Nonnull ResourceLocation model, @Nonnull Item.Properties properties) {
        this(level, storageSize, model, false, 0, 24, SoundEntry.WALLET_DEFAULT, properties);
    }

    public WalletItem(int level, int storageSize, @Nonnull ResourceLocation model, boolean indestructible, int bonusMagnet, int upgradeLimit, @Nonnull List<SoundEntry> coinCollectSound, @Nonnull Item.Properties properties) {
        super(properties.m_41487_(1));
        this.level = level;
        this.storageSize = storageSize;
        this.indestructible = indestructible;
        this.bonusMagnet = bonusMagnet;
        this.model = model;
        this.upgradeLimit = upgradeLimit;
        this.coinCollectSound = ImmutableList.copyOf(coinCollectSound);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        ICapabilityProvider temp;
        ArrayList<ICapabilityProvider> providers = new ArrayList<ICapabilityProvider>();
        providers.add(CapabilityMoneyViewer.createProvider(new WalletMoneyViewer(stack)));
        if (LCCurios.isLoaded() && (temp = LCCurios.createWalletProvider(stack)) != null) {
            providers.add(temp);
        }
        return new MixedCapabilityProvider(providers);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 10;
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return true;
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (this.bonusMagnet > 0 && enchantment == ModEnchantments.COIN_MAGNET.get()) {
            return super.getEnchantmentLevel(stack, enchantment) + this.bonusMagnet;
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map map = super.getAllEnchantments(stack);
        if (this.bonusMagnet > 0) {
            map.put((Enchantment)ModEnchantments.COIN_MAGNET.get(), map.getOrDefault(ModEnchantments.COIN_MAGNET.get(), 0) + this.bonusMagnet);
        }
        return map;
    }

    public boolean m_41386_(@Nonnull DamageSource source) {
        if (this.indestructible) {
            return false;
        }
        return super.m_41386_(source);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (this.indestructible) {
            if (entity.m_32059_() >= 0 && !entity.m_9236_().f_46443_) {
                entity.m_149678_();
            }
            if (entity.m_20182_().f_82480_ <= (double)entity.m_9236_().m_141937_()) {
                Vec3 velocity = entity.m_20184_();
                entity.m_20256_(new Vec3(velocity.f_82479_, 0.5, velocity.f_82481_));
            }
        }
        return false;
    }

    public boolean m_142305_(@Nonnull ItemStack wallet, @Nonnull ItemStack item, @Nonnull Slot slot, @Nonnull ClickAction action, @Nonnull Player player, @Nonnull SlotAccess slotAccess) {
        Item item2;
        if (action == ClickAction.SECONDARY && ((Boolean)LCConfig.SERVER.walletCapacityUpgradeable.get()).booleanValue() && InventoryUtil.ItemHasTag(item, LCTags.Items.WALLET_UPGRADE_MATERIAL) && (item2 = wallet.m_41720_()) instanceof WalletItem) {
            WalletItem walletItem = (WalletItem)item2;
            CompoundTag tag = wallet.m_41784_();
            int bonusSlots = tag.m_128451_("BonusSlots");
            if (bonusSlots >= walletItem.upgradeLimit) {
                return true;
            }
            if (player.f_36096_ instanceof WalletMenuBase) {
                return true;
            }
            item.m_41774_(1);
            tag.m_128405_("BonusSlots", Math.min(walletItem.upgradeLimit, bonusSlots + 6));
            slot.m_5852_(wallet);
            return true;
        }
        return false;
    }

    public static boolean validWalletStack(ItemStack walletStack) {
        if (walletStack.m_41619_()) {
            return true;
        }
        return WalletItem.isWallet(walletStack.m_41720_());
    }

    public static boolean isWallet(ItemStack item) {
        return !item.m_41619_() && WalletItem.isWallet(item.m_41720_());
    }

    public static boolean isWallet(Item item) {
        return item instanceof WalletItem;
    }

    public static boolean CanExchange(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)LCConfig.SERVER.walletExchangeLevel.get();
    }

    public static boolean CanPickup(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)LCConfig.SERVER.walletPickupLevel.get();
    }

    public static boolean HasBankAccess(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)LCConfig.SERVER.walletBankLevel.get();
    }

    public static int BonusSlots(@Nonnull ItemStack walletStack) {
        Item item = walletStack.m_41720_();
        if (item instanceof WalletItem) {
            WalletItem wallet = (WalletItem)item;
            CompoundTag tag = walletStack.m_41784_();
            return Math.min(wallet.upgradeLimit, tag.m_128451_("BonusSlots"));
        }
        return 0;
    }

    public static int InventorySize(@Nonnull ItemStack walletStack) {
        Item item = walletStack.m_41720_();
        if (item instanceof WalletItem) {
            WalletItem wallet = (WalletItem)item;
            return wallet.storageSize + WalletItem.BonusSlots(walletStack);
        }
        return 0;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        MoneyView contents;
        super.m_7373_(stack, level, tooltip, flagIn);
        tooltip.add((Component)LCText.TOOLTIP_WALLET_CAPACITY.get(WalletItem.InventorySize(stack)).m_130940_(ChatFormatting.YELLOW));
        int bonusSlots = WalletItem.BonusSlots(stack);
        Item item = stack.m_41720_();
        if (item instanceof WalletItem) {
            ItemStack exampleItem;
            WalletItem wallet = (WalletItem)item;
            if (bonusSlots < wallet.upgradeLimit && !(exampleItem = ListUtil.randomItemFromList(InventoryUtil.GetItemStacksWithTag(LCTags.Items.WALLET_UPGRADE_MATERIAL), ItemStack.f_41583_)).m_41619_()) {
                tooltip.addAll(TooltipHelper.splitTooltips((Component)LCText.TOOLTIP_WALLET_UPGRADEABLE_CAPACITY.get(TooltipHelper.lazyFormat(exampleItem.m_41786_(), ChatFormatting.AQUA), TooltipHelper.lazyFormat(String.valueOf(6), ChatFormatting.GOLD)), ChatFormatting.YELLOW));
            }
        }
        if (WalletItem.CanPickup(this)) {
            tooltip.add((Component)LCText.TOOLTIP_WALLET_PICKUP.get(new Object[0]).m_130940_(ChatFormatting.YELLOW));
        }
        if (WalletItem.CanExchange(this)) {
            if (WalletItem.CanPickup(this)) {
                MutableComponent onOffText = WalletItem.getAutoExchange(stack) ? LCText.TOOLTIP_WALLET_EXCHANGE_AUTO_ON.get(new Object[0]).m_130940_(ChatFormatting.GREEN) : LCText.TOOLTIP_WALLET_EXCHANGE_AUTO_OFF.get(new Object[0]).m_130940_(ChatFormatting.RED);
                tooltip.add((Component)LCText.TOOLTIP_WALLET_EXCHANGE_AUTO.get(onOffText).m_130940_(ChatFormatting.YELLOW));
            } else {
                tooltip.add((Component)LCText.TOOLTIP_WALLET_EXCHANGE_MANUAL.get(new Object[0]).m_130940_(ChatFormatting.YELLOW));
            }
        }
        if (WalletItem.HasBankAccess(this)) {
            tooltip.add((Component)LCText.TOOLTIP_WALLET_BANK_ACCOUNT.get(new Object[0]).m_130940_(ChatFormatting.YELLOW));
        }
        WalletEnchantment.addWalletEnchantmentTooltips(tooltip, stack);
        if (CoinAPI.API.NoDataAvailable()) {
            return;
        }
        IMoneyViewer handler = CapabilityMoneyViewer.getCapability(stack);
        if (handler != null && !(contents = handler.getStoredMoney()).isEmpty()) {
            tooltip.add((Component)LCText.TOOLTIP_WALLET_STORED_MONEY.get(new Object[0]));
            tooltip.addAll(contents.getAllText(ChatFormatting.DARK_GREEN));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack wallet = player.m_21120_(hand);
        if (!world.f_46443_) {
            int walletSlot = WalletItem.GetWalletSlot(player.m_150109_(), wallet);
            if (walletSlot >= 0) {
                IWalletHandler walletHandler;
                if (player.m_6047_() && !LCCurios.isLoaded() && (walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player)) != null && walletHandler.getWallet().m_41619_()) {
                    walletHandler.setWallet(wallet);
                    player.m_21008_(hand, ItemStack.f_41583_);
                    new SPacketSyncWallet(player.m_19879_(), walletHandler.getWallet(), walletHandler.visible()).sendTo(player);
                    walletHandler.clean();
                    walletSlot = -1;
                }
                WalletMenuBase.SafeOpenWalletMenu((ServerPlayer)player, walletSlot);
            } else {
                LightmansCurrency.LogError("Could not find the wallet in the players inventory!");
            }
        } else {
            player.m_9236_().m_5594_(player, player.m_20183_(), emptyOpenSound, SoundSource.PLAYERS, 0.75f, 1.25f + player.m_9236_().f_46441_.m_188501_() * 0.5f);
            if (!WalletItem.isEmpty(wallet)) {
                player.m_9236_().m_5594_(player, player.m_20183_(), (SoundEvent)ModSounds.COINS_CLINKING.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
            }
        }
        return InteractionResultHolder.m_19090_((Object)wallet);
    }

    public static boolean isEmpty(@Nonnull ItemStack wallet) {
        return WalletItem.getWalletInventory(wallet).m_7983_();
    }

    private static int GetWalletSlot(Inventory inventory, ItemStack wallet) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i) != wallet) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack PickupCoin(ItemStack wallet, ItemStack coins) {
        SimpleContainer inventory = WalletItem.getWalletInventory(wallet);
        ItemStack returnValue = InventoryUtil.TryPutItemStack((Container)inventory, coins);
        if (WalletItem.getAutoExchange(wallet)) {
            CoinAPI.API.CoinExchangeAllUp((Container)inventory);
        }
        CoinAPI.API.SortCoinsByValue((Container)inventory);
        WalletItem.putWalletInventory(wallet, (Container)inventory);
        return returnValue;
    }

    public static void putWalletInventory(@Nonnull ItemStack wallet, @Nonnull Container inventory) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return;
        }
        InventoryUtil.saveAllItems("Items", wallet.m_41784_(), inventory);
    }

    @Nonnull
    public static SimpleContainer getWalletInventory(@Nonnull ItemStack wallet) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return new SimpleContainer(new ItemStack[0]);
        }
        CompoundTag compound = wallet.m_41784_();
        int inventorySize = WalletItem.InventorySize(wallet);
        if (!compound.m_128441_("Items")) {
            return new SimpleContainer(inventorySize);
        }
        return InventoryUtil.loadAllItems("Items", compound, inventorySize);
    }

    public static boolean getAutoExchange(ItemStack wallet) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return false;
        }
        if (!WalletItem.CanExchange((WalletItem)wallet.m_41720_()) || !WalletItem.CanPickup((WalletItem)wallet.m_41720_())) {
            return false;
        }
        CompoundTag tag = wallet.m_41784_();
        if (!tag.m_128441_("AutoConvert")) {
            tag.m_128379_("AutoConvert", true);
            return true;
        }
        return tag.m_128471_("AutoConvert");
    }

    public static void toggleAutoExchange(ItemStack wallet) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return;
        }
        if (!WalletItem.CanExchange((WalletItem)wallet.m_41720_())) {
            return;
        }
        CompoundTag tag = wallet.m_41784_();
        boolean oldValue = WalletItem.getAutoExchange(wallet);
        tag.m_128379_("AutoConvert", !oldValue);
    }

    public static void QuickCollect(Player player, Container container, boolean allowSideChain) {
        ItemStack wallet = CoinAPI.API.getEquippedWallet(player);
        if (WalletItem.isWallet(wallet)) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!CoinAPI.API.IsAllowedInCoinContainer(stack, allowSideChain)) continue;
                stack = WalletItem.PickupCoin(wallet, stack);
                container.m_6836_(i, stack);
            }
        }
    }

    public static void playCollectSound(@Nonnull LivingEntity entity, @Nonnull ItemStack wallet) {
        Level level = entity.m_9236_();
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(WalletItem.getCoinCollectSound(level, wallet));
        if (sound != null) {
            level.m_6269_(null, (Entity)entity, sound, SoundSource.PLAYERS, 0.4f, 1.0f);
        }
    }

    @Nonnull
    public static ResourceLocation getCoinCollectSound(@Nonnull Level level, @Nonnull ItemStack wallet) {
        Item item = wallet.m_41720_();
        if (item instanceof WalletItem) {
            WalletItem item2 = (WalletItem)item;
            return SoundEntry.getRandomEntry(level.m_213780_(), item2.coinCollectSound, DEFAULT_COIN_COLLECT_SOUND);
        }
        return DEFAULT_COIN_COLLECT_SOUND;
    }

    public static class Colored
    extends WalletItem
    implements DyeableLeatherItem {
        public Colored(int level, int storageSize, @Nonnull ResourceLocation model, @Nonnull Item.Properties properties) {
            super(level, storageSize, model, properties);
        }

        public Colored(int level, int storageSize, @Nonnull ResourceLocation model, boolean indestructible, int bonusMagnet, int upgradeLimit, @Nonnull List<SoundEntry> coinCollectSound, @Nonnull Item.Properties properties) {
            super(level, storageSize, model, indestructible, bonusMagnet, upgradeLimit, coinCollectSound, properties);
        }
    }
}

