/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeItem;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeableBlock;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class UpgradeItem
extends Item
implements IUpgradeItem {
    protected final UpgradeType upgradeType;
    private boolean addTooltips = true;
    Function<UpgradeData, List<Component>> customTooltips = null;

    public UpgradeItem(UpgradeType upgradeType, Item.Properties properties) {
        super(properties);
        this.upgradeType = upgradeType;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41782_() && player.m_6047_()) {
            boolean removed = false;
            CompoundTag tag = stack.m_41783_();
            if (tag.m_128441_("UpgradeData")) {
                tag.m_128473_("UpgradeData");
                removed = true;
            }
            if (tag.m_128441_("Active")) {
                tag.m_128473_("Active");
                removed = true;
            }
            boolean bl = removed = removed || this.upgradeType.clearDataFromStack(stack);
            if (removed) {
                level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.35f + 0.9f, false);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        Block block = state.m_60734_();
        if (block instanceof IUpgradeableBlock) {
            IUpgradeableBlock block2 = (IUpgradeableBlock)block;
            IUpgradeable upgradeable = block2.getUpgradeable(level, pos, state);
            Player player = context.m_43723_();
            if (upgradeable == null || !block2.canUseUpgradeItem(upgradeable, stack, player)) {
                return InteractionResult.PASS;
            }
            if (upgradeable.quickInsertUpgrade(stack)) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public final boolean addsTooltips() {
        return this.addTooltips;
    }

    protected final void ignoreTooltips() {
        this.addTooltips = false;
    }

    protected final void setCustomTooltips(Function<UpgradeData, List<Component>> customTooltips) {
        this.customTooltips = customTooltips;
    }

    @Override
    @Nonnull
    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    @Override
    public abstract void setDefaultValues(@Nonnull UpgradeData.Mutable var1);

    @Nonnull
    public static UpgradeData getUpgradeData(@Nonnull ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof UpgradeItem) {
            CompoundTag tag;
            UpgradeItem upgrade = (UpgradeItem)item;
            UpgradeData.Mutable data = UpgradeData.EMPTY.makeMutable();
            upgrade.setDefaultValues(data);
            if (stack.m_41782_() && (tag = stack.m_41783_()).m_128425_("UpgradeData", 10)) {
                UpgradeData tagData = UpgradeData.parse(tag.m_128469_("UpgradeData"));
                data.merge(tagData);
            }
            return data.makeImmutable();
        }
        return UpgradeData.EMPTY;
    }

    public static void setUpgradeData(@Nonnull ItemStack stack, @Nonnull UpgradeData data) {
        Item item = stack.m_41720_();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            CompoundTag tag = stack.m_41784_();
            tag.m_128365_("UpgradeData", (Tag)data.save());
        }
    }

    public static List<Component> getUpgradeTooltip(@Nonnull ItemStack stack, @Nullable Level context) {
        try {
            return UpgradeItem.getUpgradeTooltip(stack, false, context);
        }
        catch (Throwable throwable) {
            return new ArrayList<Component>();
        }
    }

    public static List<Component> getUpgradeTooltip(@Nonnull ItemStack stack, boolean forceCollection, @Nullable Level context) {
        Item item = stack.m_41720_();
        if (item instanceof UpgradeItem) {
            List<Component> targets;
            UpgradeItem item2 = (UpgradeItem)item;
            if (!item2.addTooltips && !forceCollection) {
                return new ArrayList<Component>();
            }
            UpgradeType type = item2.getUpgradeType();
            UpgradeData data = UpgradeItem.getUpgradeData(stack);
            if (item2.customTooltips != null) {
                return (List)item2.customTooltips.apply((Object)data);
            }
            ArrayList<Component> tooltip = new ArrayList<Component>(type.getTooltip(data));
            tooltip.addAll(type.getTooltipWithContext(data, context));
            if (type.isUnique()) {
                tooltip.add((Component)LCText.TOOLTIP_UPGRADE_UNIQUE.getWithStyle(ChatFormatting.BOLD, ChatFormatting.GOLD));
            }
            if (!(targets = type.getPossibleTargets()).isEmpty()) {
                tooltip.add((Component)LCText.TOOLTIP_UPGRADE_TARGETS.getWithStyle(ChatFormatting.GRAY));
                for (Component target : targets) {
                    MutableComponent mc = EasyText.makeMutable(target);
                    tooltip.add((Component)mc.m_130940_(ChatFormatting.GRAY));
                }
            }
            return tooltip;
        }
        return Lists.newArrayList();
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        List<Component> upgradeTooltips = UpgradeItem.getUpgradeTooltip(stack, level);
        if (upgradeTooltips != null) {
            tooltip.addAll(upgradeTooltips);
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    public static boolean noUniqueConflicts(@Nonnull UpgradeItem item, @Nonnull Container container) {
        UpgradeType type = item.getUpgradeType();
        if (type.isUnique()) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                UpgradeItem otherItem;
                Item item2;
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_() || !((item2 = stack.m_41720_()) instanceof UpgradeItem) || (otherItem = (UpgradeItem)item2).getUpgradeType() != type) continue;
                return false;
            }
        }
        return true;
    }

    public static class Simple
    extends UpgradeItem {
        public Simple(UpgradeType upgradeType, Item.Properties properties) {
            super(upgradeType, properties);
        }

        @Override
        public void setDefaultValues(@Nonnull UpgradeData.Mutable data) {
        }
    }
}

