/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.common.blockentity.MoneyBagBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MoneyBagItem
extends BlockItem {
    public static final ResourceLocation PROPERTY = VersionUtil.lcResource("money_bag_size");

    public MoneyBagItem(Block block, Item.Properties properties) {
        super(block, properties.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level context, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag;
        TooltipItem.addTooltip(tooltip, LCText.TOOLTIP_MONEY_BAG);
        List<ItemStack> contents = MoneyBagItem.getContents(stack);
        if (!contents.isEmpty()) {
            if (Screen.m_96637_()) {
                for (ItemStack coin : contents) {
                    if (coin.m_41613_() > 1) {
                        tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_CONTENTS_MULTIPLE.get(coin.m_41613_(), coin.m_41786_()));
                        continue;
                    }
                    tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_CONTENTS_SINGLE.get(coin.m_41786_()));
                }
            } else {
                tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_HOLD_CTRL.get(new Object[0]).m_130940_(ChatFormatting.YELLOW));
            }
        }
        if (flag.m_7050_()) {
            tooltip.add((Component)LCText.TOOLTIP_MONEY_BAG_SIZE.get(MoneyBagItem.getSize(stack)).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if ((tag = stack.m_41783_()) != null && tag.m_128441_("LootTable")) {
            tooltip.add((Component)LCText.TOOLTIP_CONTAINER_ITEM_LOOT_TABLE.get(tag.m_128461_("LootTable")).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        List<ItemStack> contents;
        ItemStack droppedCoin;
        int size = MoneyBagItem.getSize(stack);
        attacker.m_5496_((SoundEvent)ModSounds.COINS_CLINKING.get(), 0.25f + 0.2f * (float)size, 1.0f);
        double dropChance = (Double)LCConfig.SERVER.moneyBagCoinLossChance.get();
        RandomSource random = attacker.m_217043_();
        if (dropChance > 0.0 && random.m_188500_() < dropChance && !(droppedCoin = MoneyBagBlockEntity.removeRandomItem(contents = MoneyBagItem.getContents(stack), random)).m_41619_()) {
            MoneyBagItem.setContents(stack, contents);
            Level level = attacker.m_9236_();
            Vec3 position = attacker.m_146892_();
            Vec3 lookdirection = attacker.m_20154_();
            double averageSpeed = 5.0;
            double maxDelta = 0.25;
            Vec3 itemSpeed = lookdirection.m_82542_(random.m_216328_(averageSpeed, maxDelta), random.m_216328_(averageSpeed, maxDelta), random.m_216328_(averageSpeed, maxDelta));
            ItemEntity item = new ItemEntity(level, position.f_82479_, position.f_82480_, position.f_82481_, droppedCoin);
            item.m_20256_(itemSpeed);
            item.m_32052_(attacker.m_20148_());
            level.m_7967_((Entity)item);
        }
        return true;
    }

    public static List<ItemStack> getContents(ItemStack moneybag) {
        if (moneybag.m_41720_() instanceof MoneyBagItem) {
            CompoundTag tag = moneybag.m_41783_();
            if (tag == null || !tag.m_128441_("Contents")) {
                return new ArrayList<ItemStack>();
            }
            ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
            ListTag list = tag.m_128437_("Contents", 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack item = InventoryUtil.loadItemNoLimits(list.m_128728_(i));
                if (item.m_41619_()) continue;
                contents.add(item);
            }
            return contents;
        }
        return new ArrayList<ItemStack>();
    }

    public static void setContents(ItemStack moneyBag, List<ItemStack> contents) {
        if (moneyBag.m_41720_() instanceof MoneyBagItem) {
            CompoundTag tag = moneyBag.m_41784_();
            ListTag list = new ListTag();
            for (ItemStack item : contents) {
                if (item.m_41619_()) continue;
                list.add((Object)InventoryUtil.saveItemNoLimits(item));
            }
            tag.m_128365_("Contents", (Tag)list);
            tag.m_128405_("Size", MoneyBagBlockEntity.getBlockSize(contents));
        }
    }

    public static int getSize(ItemStack moneybag) {
        if (moneybag.m_41720_() instanceof MoneyBagItem) {
            CompoundTag tag = moneybag.m_41783_();
            if (tag == null || !tag.m_128441_("Size")) {
                return 0;
            }
            return MathUtil.clamp(tag.m_128451_("Size"), 0, 3);
        }
        return 0;
    }

    public static ItemStack createItem(ItemLike item, List<ItemStack> contents) {
        ItemStack stack = new ItemStack(item);
        if (contents.isEmpty()) {
            return stack;
        }
        MoneyBagItem.setContents(stack, contents);
        return stack;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack item) {
        float speed;
        if (slot != EquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, item);
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        int size = MoneyBagItem.getSize(item);
        float damage = ((Float)LCConfig.SERVER.moneyBagBaseAttack.get()).floatValue() + ((Float)LCConfig.SERVER.moneyBagAttackPerSize.get()).floatValue() * (float)size;
        if (damage != 0.0f) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
        }
        if ((speed = ((Float)LCConfig.SERVER.moneyBagBaseAtkSpeed.get()).floatValue() + ((Float)LCConfig.SERVER.moneyBagAtkSpeedPerSize.get()).floatValue() * (float)size) != 0.0f) {
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)speed, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }
}

