/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.items.colored.ColoredItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CoinJarItem
extends BlockItem {
    public CoinJarItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, LCText.TOOLTIP_COIN_JAR);
        List<ItemStack> jarStorage = CoinJarItem.readJarData(stack);
        if (!jarStorage.isEmpty()) {
            if (Screen.m_96637_()) {
                for (ItemStack coin : jarStorage) {
                    if (coin.m_41613_() > 1) {
                        tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_CONTENTS_MULTIPLE.get(coin.m_41613_(), coin.m_41786_()));
                        continue;
                    }
                    tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_CONTENTS_SINGLE.get(coin.m_41786_()));
                }
            } else {
                tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_HOLD_CTRL.getWithStyle(ChatFormatting.YELLOW));
            }
        }
    }

    private static List<ItemStack> readJarData(ItemStack stack) {
        CompoundTag jarData;
        CompoundTag compound;
        ArrayList<ItemStack> storage = new ArrayList<ItemStack>();
        if (stack.m_41782_() && (compound = stack.m_41783_()).m_128425_("JarData", 10) && (jarData = compound.m_128469_("JarData")).m_128441_("Coins")) {
            ListTag storageList = jarData.m_128437_("Coins", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundTag thisItem = storageList.m_128728_(i);
                storage.add(ItemStack.m_41712_((CompoundTag)thisItem));
            }
        }
        return storage;
    }

    public static class Colored
    extends CoinJarItem
    implements ColoredItem {
        public Colored(Block block, Item.Properties properties) {
            super(block, properties);
        }

        @Override
        public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
            tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_COLORED.get(new Object[0]));
            super.m_7373_(stack, level, tooltip, flagIn);
        }
    }
}

