/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.enchantments.data.BonusForEnchantment;
import io.github.lightman314.lightmanscurrency.common.enchantments.data.ItemOverride;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.message.wallet.SPacketPlayCoinSound;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.registries.ForgeRegistries;

public class MoneyMendingEnchantment
extends Enchantment {
    public MoneyMendingEnchantment(Enchantment.Rarity rarity, EquipmentSlot ... slots) {
        super(rarity, EnchantmentCategory.BREAKABLE, slots);
    }

    public int m_6183_(int level) {
        return level * 25;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + 50;
    }

    public boolean m_6591_() {
        return true;
    }

    public int m_6586_() {
        return 1;
    }

    protected boolean m_5975_(@Nonnull Enchantment otherEnchant) {
        return otherEnchant != Enchantments.f_44962_ && super.m_5975_(otherEnchant);
    }

    public static MoneyValue getRepairCost(@Nonnull ItemStack item) {
        MoneyValue base = (MoneyValue)LCConfig.SERVER.moneyMendingRepairCost.get();
        for (ItemOverride io : (List)LCConfig.SERVER.moneyMendingItemOverrides.get()) {
            if (!io.matches(item)) continue;
            base = io.baseCost;
        }
        MoneyValue total = base;
        Map enchantments = item.getAllEnchantments();
        for (Enchantment e : enchantments.keySet()) {
            ResourceLocation enchantment = ForgeRegistries.ENCHANTMENTS.getKey((Object)e);
            for (BonusForEnchantment b : (List)LCConfig.SERVER.moneyMendingBonusForEnchantments.get()) {
                int level;
                MoneyValue toAdd;
                MoneyValue newTotal;
                if (!enchantment.equals((Object)b.enchantment) || (newTotal = total.addValue(toAdd = b.bonusCost.percentageOfValue((level = Math.min((Integer)enchantments.get(e), Math.max(1, b.maxLevelCalculation <= 0 ? Integer.MAX_VALUE : b.maxLevelCalculation))) * 100))) == null) continue;
                total = newTotal;
            }
        }
        return total == null ? base : total;
    }

    public static void runEntityTick(@Nonnull LivingEntity entity, @Nonnull IMoneyHandler handler) {
        Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)((Enchantment)ModEnchantments.MONEY_MENDING.get()), (LivingEntity)entity, ItemStack::m_41768_);
        ItemStack item = entry == null ? (LCCurios.isLoaded() ? LCCurios.getRandomItem(entity, s -> s.m_41768_() && EnchantmentHelper.m_44831_((ItemStack)s).containsKey(ModEnchantments.MONEY_MENDING.get())) : null) : (ItemStack)entry.getValue();
        if (item != null) {
            MoneyValue repairCost = MoneyMendingEnchantment.getRepairCost(item);
            MoneyView availableFunds = handler.getStoredMoney();
            if (!availableFunds.containsValue(repairCost)) {
                return;
            }
            MoneyValue nextCost = repairCost;
            MoneyValue finalCost = MoneyValue.empty();
            int currentDamage = item.m_41773_();
            int repairAmount = 0;
            while (availableFunds.containsValue(nextCost) && repairAmount < currentDamage) {
                ++repairAmount;
                finalCost = nextCost;
                nextCost = nextCost.addValue(repairCost);
            }
            if (handler.extractMoney(finalCost, true).isEmpty()) {
                handler.extractMoney(finalCost, false);
                item.m_41721_(currentDamage - repairAmount);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    SPacketPlayCoinSound.INSTANCE.sendTo(player);
                }
            }
        }
    }

    public static void addEnchantmentTooltip(@Nonnull ItemStack stack, @Nonnull List<Component> tooltip) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchantments.getOrDefault(ModEnchantments.MONEY_MENDING.get(), 0) > 0) {
            tooltip.add((Component)LCText.TOOLTIP_MONEY_MENDING_COST.get(MoneyMendingEnchantment.getRepairCost(stack).getText().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        }
    }
}

