/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data;

import io.github.lightman314.lightmanscurrency.LCRegistries;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.IServerTicker;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@FieldsAreNonnullByDefault
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class CustomSaveData
extends SavedData {
    private static final Map<ResourceLocation, CustomData> serverDataCache = new HashMap<ResourceLocation, CustomData>();
    private final CustomData data;

    @Nullable
    public static <T extends CustomData> T getData(CustomDataType<T> type) {
        ResourceLocation dataID = LCRegistries.CUSTOM_DATA.getKey(type);
        if (dataID == null) {
            LightmansCurrency.LogError("Custom Data was not registered!");
            return null;
        }
        if (!serverDataCache.containsKey(dataID)) {
            LightmansCurrency.LogWarning("Attempted to get custom data '" + dataID + "' before the server started!", new Throwable());
            return null;
        }
        return (T)serverDataCache.get(dataID);
    }

    public static boolean isLoaded(CustomDataType<?> type) {
        ResourceLocation dataID = LCRegistries.CUSTOM_DATA.getKey(type);
        if (dataID == null) {
            return false;
        }
        return serverDataCache.containsKey(dataID);
    }

    private static void initServerData(MinecraftServer server) {
        ServerLevel overworld = server.m_129783_();
        if (overworld == null) {
            return;
        }
        serverDataCache.clear();
        LCRegistries.CUSTOM_DATA.forEach((T type) -> {
            ResourceLocation id = LCRegistries.CUSTOM_DATA.getKey(type);
            CustomSaveData data = (CustomSaveData)overworld.m_8895_().m_164861_(t -> {
                Object d = type.create();
                ((CustomData)d).loadData((CompoundTag)t);
                return new CustomSaveData((CustomData)d);
            }, () -> new CustomSaveData((CustomData)type.create()), type.fileName);
            serverDataCache.put(id, data.data);
        });
    }

    private CustomSaveData(@Nonnull CustomData data) {
        this.data = data;
        this.data.initServer(() -> ((CustomSaveData)this).m_77762_());
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        this.data.save(tag);
        return tag;
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CustomSaveData.forEach(data -> data.onPlayerJoin(player2));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        CustomSaveData.forEach(data -> {
            Object ticker;
            if (data instanceof IEasyTickable) {
                ticker = (IEasyTickable)((Object)data);
                ticker.tick();
            }
            if (data instanceof IServerTicker) {
                ticker = (IServerTicker)((Object)data);
                ticker.serverTick();
            }
        });
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        CustomSaveData.initServerData(event.getServer());
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppedEvent event) {
        serverDataCache.clear();
    }

    private static void forEach(Consumer<CustomData> consumer) {
        serverDataCache.values().forEach(consumer);
    }
}

