/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core.variants;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.Tags;

@MethodsReturnNonnullByDefault
public enum Color {
    WHITE(0, 0xFFFFFF, MapColor.f_283811_, (TagKey<Item>)Tags.Items.DYES_WHITE),
    LIGHT_GRAY(1, 0x9D9D97, MapColor.f_283779_, (TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY),
    GRAY(2, 0x646464, MapColor.f_283818_, (TagKey<Item>)Tags.Items.DYES_GRAY),
    BLACK(3, 0x141414, MapColor.f_283927_, (TagKey<Item>)Tags.Items.DYES_BLACK),
    BROWN(4, 8606770, MapColor.f_283748_, (TagKey<Item>)Tags.Items.DYES_BROWN),
    RED(5, 0xFF0000, MapColor.f_283913_, (TagKey<Item>)Tags.Items.DYES_RED),
    ORANGE(6, 0xFF7F00, MapColor.f_283750_, (TagKey<Item>)Tags.Items.DYES_ORANGE),
    YELLOW(7, 0xFFFF00, MapColor.f_283832_, (TagKey<Item>)Tags.Items.DYES_YELLOW),
    LIME(8, 8834086, MapColor.f_283916_, (TagKey<Item>)Tags.Items.DYES_LIME),
    GREEN(9, 32512, MapColor.f_283784_, (TagKey<Item>)Tags.Items.DYES_GREEN),
    CYAN(10, 1481628, MapColor.f_283772_, (TagKey<Item>)Tags.Items.DYES_CYAN),
    LIGHT_BLUE(11, 65535, MapColor.f_283869_, (TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE),
    BLUE(12, 255, MapColor.f_283743_, (TagKey<Item>)Tags.Items.DYES_BLUE),
    PURPLE(13, 9913293, MapColor.f_283889_, (TagKey<Item>)Tags.Items.DYES_PURPLE),
    MAGENTA(14, 14049489, MapColor.f_283931_, (TagKey<Item>)Tags.Items.DYES_MAGENTA),
    PINK(15, 16036553, MapColor.f_283765_, (TagKey<Item>)Tags.Items.DYES_PINK);

    public final int sortIndex;
    public final int hexColor;
    public final MapColor mapColor;
    public final TagKey<Item> dyeTag;

    public final String getResourceSafeName() {
        return this.toString().toLowerCase(Locale.ENGLISH);
    }

    public final String getPrettyName() {
        StringBuilder builder = new StringBuilder();
        boolean capitalize = true;
        String safeName = this.getResourceSafeName();
        for (int i = 0; i < safeName.length(); ++i) {
            char nextChar = safeName.charAt(i);
            if (nextChar == '_') {
                builder.append(' ');
                capitalize = true;
                continue;
            }
            if (capitalize) {
                builder.append(("" + nextChar).toUpperCase(Locale.ENGLISH));
                capitalize = false;
                continue;
            }
            builder.append(nextChar);
        }
        return builder.toString();
    }

    public final MutableComponent getComponent() {
        return Component.m_237115_((String)("color.minecraft." + this.getResourceSafeName()));
    }

    private Color(int sortIndex, int hexColor, MapColor mapColor, TagKey<Item> dyeTag) {
        this.sortIndex = sortIndex;
        this.hexColor = hexColor;
        this.mapColor = mapColor;
        this.dyeTag = dyeTag;
    }

    public static Color getFromIndex(long index) {
        index %= 16L;
        for (Color c : Color.values()) {
            if ((long)c.sortIndex != index) continue;
            return c;
        }
        return WHITE;
    }

    @Nullable
    public static Color getFromPrettyName(String name) {
        for (Color c : Color.values()) {
            if (!c.toString().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    public static int sortByColor(Color c1, Color c2) {
        return Integer.compare(c1.sortIndex, c2.sortIndex);
    }
}

